--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReadFruData = {}

---@class FrudataIpmiCmds.ReadFruDataReq
---@field FruId integer
---@field Offset integer
---@field Length integer
local TReadFruDataReq = {}
TReadFruDataReq.__index = TReadFruDataReq
TReadFruDataReq.group = {}

local function TReadFruDataReq_from_obj(obj)
    return setmetatable(obj, TReadFruDataReq)
end

function TReadFruDataReq.new(FruId, Offset, Length)
    return TReadFruDataReq_from_obj({FruId = FruId, Offset = Offset, Length = Length})
end
---@param obj FrudataIpmiCmds.ReadFruDataReq
function TReadFruDataReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TReadFruDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadFruDataReq.group)
end

TReadFruDataReq.from_obj = TReadFruDataReq_from_obj

TReadFruDataReq.proto_property = {'FruId', 'Offset', 'Length'}

TReadFruDataReq.default = {0, 0, 0}

TReadFruDataReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TReadFruDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TReadFruDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadFruDataReq.proto_property, errs, need_convert)
    return self
end

function TReadFruDataReq:unpack(_)
    return self.FruId, self.Offset, self.Length
end

ReadFruData.ReadFruDataReq = TReadFruDataReq

---@class FrudataIpmiCmds.ReadFruDataRsp
---@field CompletionCode integer
---@field Count integer
---@field Data string
local TReadFruDataRsp = {}
TReadFruDataRsp.__index = TReadFruDataRsp
TReadFruDataRsp.group = {}

local function TReadFruDataRsp_from_obj(obj)
    return setmetatable(obj, TReadFruDataRsp)
end

function TReadFruDataRsp.new(CompletionCode, Count, Data)
    return TReadFruDataRsp_from_obj({CompletionCode = CompletionCode, Count = Count, Data = Data})
end
---@param obj FrudataIpmiCmds.ReadFruDataRsp
function TReadFruDataRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Count = obj.Count
    self.Data = obj.Data
end

function TReadFruDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadFruDataRsp.group)
end

TReadFruDataRsp.from_obj = TReadFruDataRsp_from_obj

TReadFruDataRsp.proto_property = {'CompletionCode', 'Count', 'Data'}

TReadFruDataRsp.default = {0, 0, ''}

TReadFruDataRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Count', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TReadFruDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TReadFruDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadFruDataRsp.proto_property, errs, need_convert)
    return self
end

function TReadFruDataRsp:unpack(_)
    return self.CompletionCode, self.Count, self.Data
end

ReadFruData.ReadFruDataRsp = TReadFruDataRsp

return ReadFruData
