--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPicmgProperties = {}

---@class FrudataIpmiCmds.GetPicmgPropertiesReq
---@field PicmgIdentifier integer
local TGetPicmgPropertiesReq = {}
TGetPicmgPropertiesReq.__index = TGetPicmgPropertiesReq
TGetPicmgPropertiesReq.group = {}

local function TGetPicmgPropertiesReq_from_obj(obj)
    return setmetatable(obj, TGetPicmgPropertiesReq)
end

function TGetPicmgPropertiesReq.new(PicmgIdentifier)
    return TGetPicmgPropertiesReq_from_obj({PicmgIdentifier = PicmgIdentifier})
end
---@param obj FrudataIpmiCmds.GetPicmgPropertiesReq
function TGetPicmgPropertiesReq:init_from_obj(obj)
    self.PicmgIdentifier = obj.PicmgIdentifier
end

function TGetPicmgPropertiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPicmgPropertiesReq.group)
end

TGetPicmgPropertiesReq.from_obj = TGetPicmgPropertiesReq_from_obj

TGetPicmgPropertiesReq.proto_property = {'PicmgIdentifier'}

TGetPicmgPropertiesReq.default = {0}

TGetPicmgPropertiesReq.struct = {{name = 'PicmgIdentifier', is_array = false, struct = nil}}

function TGetPicmgPropertiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PicmgIdentifier', self.PicmgIdentifier, 'uint8', false, errs, need_convert)

    TGetPicmgPropertiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPicmgPropertiesReq.proto_property, errs, need_convert)
    return self
end

function TGetPicmgPropertiesReq:unpack(_)
    return self.PicmgIdentifier
end

GetPicmgProperties.GetPicmgPropertiesReq = TGetPicmgPropertiesReq

---@class FrudataIpmiCmds.GetPicmgPropertiesRsp
---@field CompletionCode integer
---@field PicmgId integer
---@field PicmgExtensionVersion integer
---@field FruCount integer
---@field FruDeviceId integer
local TGetPicmgPropertiesRsp = {}
TGetPicmgPropertiesRsp.__index = TGetPicmgPropertiesRsp
TGetPicmgPropertiesRsp.group = {}

local function TGetPicmgPropertiesRsp_from_obj(obj)
    return setmetatable(obj, TGetPicmgPropertiesRsp)
end

function TGetPicmgPropertiesRsp.new(CompletionCode, PicmgId, PicmgExtensionVersion, FruCount, FruDeviceId)
    return TGetPicmgPropertiesRsp_from_obj({
        CompletionCode = CompletionCode,
        PicmgId = PicmgId,
        PicmgExtensionVersion = PicmgExtensionVersion,
        FruCount = FruCount,
        FruDeviceId = FruDeviceId
    })
end
---@param obj FrudataIpmiCmds.GetPicmgPropertiesRsp
function TGetPicmgPropertiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PicmgId = obj.PicmgId
    self.PicmgExtensionVersion = obj.PicmgExtensionVersion
    self.FruCount = obj.FruCount
    self.FruDeviceId = obj.FruDeviceId
end

function TGetPicmgPropertiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPicmgPropertiesRsp.group)
end

TGetPicmgPropertiesRsp.from_obj = TGetPicmgPropertiesRsp_from_obj

TGetPicmgPropertiesRsp.proto_property = {
    'CompletionCode', 'PicmgId', 'PicmgExtensionVersion', 'FruCount', 'FruDeviceId'
}

TGetPicmgPropertiesRsp.default = {0, 0, 0, 0, 0}

TGetPicmgPropertiesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'PicmgId', is_array = false, struct = nil},
    {name = 'PicmgExtensionVersion', is_array = false, struct = nil},
    {name = 'FruCount', is_array = false, struct = nil}, {name = 'FruDeviceId', is_array = false, struct = nil}
}

function TGetPicmgPropertiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgId', self.PicmgId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgExtensionVersion', self.PicmgExtensionVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruCount', self.FruCount, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruDeviceId', self.FruDeviceId, 'uint8', false, errs, need_convert)

    TGetPicmgPropertiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPicmgPropertiesRsp.proto_property, errs, need_convert)
    return self
end

function TGetPicmgPropertiesRsp:unpack(_)
    return self.CompletionCode, self.PicmgId, self.PicmgExtensionVersion, self.FruCount, self.FruDeviceId
end

GetPicmgProperties.GetPicmgPropertiesRsp = TGetPicmgPropertiesRsp

return GetPicmgProperties
