--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetGeneralDeviceManufacture = {}

---@class FrudataIpmiCmds.GetGeneralDeviceManufactureReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetGeneralDeviceManufactureReq = {}
TGetGeneralDeviceManufactureReq.__index = TGetGeneralDeviceManufactureReq
TGetGeneralDeviceManufactureReq.group = {}

local function TGetGeneralDeviceManufactureReq_from_obj(obj)
    return setmetatable(obj, TGetGeneralDeviceManufactureReq)
end

function TGetGeneralDeviceManufactureReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetGeneralDeviceManufactureReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetGeneralDeviceManufactureReq
function TGetGeneralDeviceManufactureReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetGeneralDeviceManufactureReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetGeneralDeviceManufactureReq.group)
end

TGetGeneralDeviceManufactureReq.from_obj = TGetGeneralDeviceManufactureReq_from_obj

TGetGeneralDeviceManufactureReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetGeneralDeviceManufactureReq.default = {0, 0, 0, 0, 0}

TGetGeneralDeviceManufactureReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetGeneralDeviceManufactureReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetGeneralDeviceManufactureReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetGeneralDeviceManufactureReq.proto_property, errs, need_convert)
    return self
end

function TGetGeneralDeviceManufactureReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetGeneralDeviceManufacture.GetGeneralDeviceManufactureReq = TGetGeneralDeviceManufactureReq

---@class FrudataIpmiCmds.GetGeneralDeviceManufactureRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field DeviceManufactureName string
local TGetGeneralDeviceManufactureRsp = {}
TGetGeneralDeviceManufactureRsp.__index = TGetGeneralDeviceManufactureRsp
TGetGeneralDeviceManufactureRsp.group = {}

local function TGetGeneralDeviceManufactureRsp_from_obj(obj)
    return setmetatable(obj, TGetGeneralDeviceManufactureRsp)
end

function TGetGeneralDeviceManufactureRsp.new(CompletionCode, ManufactureId, EndOfList, DeviceManufactureName)
    return TGetGeneralDeviceManufactureRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        DeviceManufactureName = DeviceManufactureName
    })
end
---@param obj FrudataIpmiCmds.GetGeneralDeviceManufactureRsp
function TGetGeneralDeviceManufactureRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.DeviceManufactureName = obj.DeviceManufactureName
end

function TGetGeneralDeviceManufactureRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetGeneralDeviceManufactureRsp.group)
end

TGetGeneralDeviceManufactureRsp.from_obj = TGetGeneralDeviceManufactureRsp_from_obj

TGetGeneralDeviceManufactureRsp.proto_property = {
    'CompletionCode', 'ManufactureId', 'EndOfList', 'DeviceManufactureName'
}

TGetGeneralDeviceManufactureRsp.default = {0, 0, 0, ''}

TGetGeneralDeviceManufactureRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil},
    {name = 'DeviceManufactureName', is_array = false, struct = nil}
}

function TGetGeneralDeviceManufactureRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceManufactureName', self.DeviceManufactureName, 'string', false, errs, need_convert)

    TGetGeneralDeviceManufactureRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetGeneralDeviceManufactureRsp.proto_property, errs, need_convert)
    return self
end

function TGetGeneralDeviceManufactureRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.DeviceManufactureName
end

GetGeneralDeviceManufacture.GetGeneralDeviceManufactureRsp = TGetGeneralDeviceManufactureRsp

return GetGeneralDeviceManufacture
