--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFruidInfo = {}

---@class FrudataIpmiCmds.GetFruidInfoReq
---@field ManufactureId integer
---@field DeviceType integer
---@field GroupId integer
---@field DeviceNumber integer
---@field ReservedH integer
---@field ReadOffset integer
---@field Length integer
local TGetFruidInfoReq = {}
TGetFruidInfoReq.__index = TGetFruidInfoReq
TGetFruidInfoReq.group = {}

local function TGetFruidInfoReq_from_obj(obj)
    return setmetatable(obj, TGetFruidInfoReq)
end

function TGetFruidInfoReq.new(ManufactureId, DeviceType, GroupId, DeviceNumber, ReservedH, ReadOffset, Length)
    return TGetFruidInfoReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        GroupId = GroupId,
        DeviceNumber = DeviceNumber,
        ReservedH = ReservedH,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetFruidInfoReq
function TGetFruidInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.GroupId = obj.GroupId
    self.DeviceNumber = obj.DeviceNumber
    self.ReservedH = obj.ReservedH
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetFruidInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruidInfoReq.group)
end

TGetFruidInfoReq.from_obj = TGetFruidInfoReq_from_obj

TGetFruidInfoReq.proto_property = {
    'ManufactureId', 'DeviceType', 'GroupId', 'DeviceNumber', 'ReservedH', 'ReadOffset', 'Length'
}

TGetFruidInfoReq.default = {0, 0, 0, 0, 0, 0, 0}

TGetFruidInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'GroupId', is_array = false, struct = nil}, {name = 'DeviceNumber', is_array = false, struct = nil},
    {name = 'ReservedH', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetFruidInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'GroupId', self.GroupId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReservedH', self.ReservedH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetFruidInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruidInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetFruidInfoReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.GroupId, self.DeviceNumber, self.ReservedH, self.ReadOffset,
        self.Length
end

GetFruidInfo.GetFruidInfoReq = TGetFruidInfoReq

---@class FrudataIpmiCmds.GetFruidInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndofList integer
---@field Data string
local TGetFruidInfoRsp = {}
TGetFruidInfoRsp.__index = TGetFruidInfoRsp
TGetFruidInfoRsp.group = {}

local function TGetFruidInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetFruidInfoRsp)
end

function TGetFruidInfoRsp.new(CompletionCode, ManufactureId, EndofList, Data)
    return TGetFruidInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndofList = EndofList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetFruidInfoRsp
function TGetFruidInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndofList = obj.EndofList
    self.Data = obj.Data
end

function TGetFruidInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruidInfoRsp.group)
end

TGetFruidInfoRsp.from_obj = TGetFruidInfoRsp_from_obj

TGetFruidInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndofList', 'Data'}

TGetFruidInfoRsp.default = {0, 0, 0, ''}

TGetFruidInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndofList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetFruidInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndofList', self.EndofList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetFruidInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruidInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetFruidInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndofList, self.Data
end

GetFruidInfo.GetFruidInfoRsp = TGetFruidInfoRsp

return GetFruidInfo
