--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceUniqueId = {}

---@class FrudataIpmiCmds.GetDeviceUniqueIdReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDeviceUniqueIdReq = {}
TGetDeviceUniqueIdReq.__index = TGetDeviceUniqueIdReq
TGetDeviceUniqueIdReq.group = {}

local function TGetDeviceUniqueIdReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceUniqueIdReq)
end

function TGetDeviceUniqueIdReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetDeviceUniqueIdReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetDeviceUniqueIdReq
function TGetDeviceUniqueIdReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDeviceUniqueIdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceUniqueIdReq.group)
end

TGetDeviceUniqueIdReq.from_obj = TGetDeviceUniqueIdReq_from_obj

TGetDeviceUniqueIdReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDeviceUniqueIdReq.default = {0, 0, 0, 0, 0}

TGetDeviceUniqueIdReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceUniqueIdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceUniqueIdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceUniqueIdReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceUniqueIdReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDeviceUniqueId.GetDeviceUniqueIdReq = TGetDeviceUniqueIdReq

---@class FrudataIpmiCmds.GetDeviceUniqueIdRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDeviceUniqueIdRsp = {}
TGetDeviceUniqueIdRsp.__index = TGetDeviceUniqueIdRsp
TGetDeviceUniqueIdRsp.group = {}

local function TGetDeviceUniqueIdRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceUniqueIdRsp)
end

function TGetDeviceUniqueIdRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDeviceUniqueIdRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetDeviceUniqueIdRsp
function TGetDeviceUniqueIdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDeviceUniqueIdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceUniqueIdRsp.group)
end

TGetDeviceUniqueIdRsp.from_obj = TGetDeviceUniqueIdRsp_from_obj

TGetDeviceUniqueIdRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDeviceUniqueIdRsp.default = {0, 0, 0, ''}

TGetDeviceUniqueIdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDeviceUniqueIdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDeviceUniqueIdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceUniqueIdRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceUniqueIdRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDeviceUniqueId.GetDeviceUniqueIdRsp = TGetDeviceUniqueIdRsp

return GetDeviceUniqueId
