--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceName = {}

---@class FrudataIpmiCmds.GetDeviceNameReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDeviceNameReq = {}
TGetDeviceNameReq.__index = TGetDeviceNameReq
TGetDeviceNameReq.group = {}

local function TGetDeviceNameReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceNameReq)
end

function TGetDeviceNameReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetDeviceNameReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetDeviceNameReq
function TGetDeviceNameReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDeviceNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceNameReq.group)
end

TGetDeviceNameReq.from_obj = TGetDeviceNameReq_from_obj

TGetDeviceNameReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDeviceNameReq.default = {0, 0, 0, 0, 0}

TGetDeviceNameReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceNameReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceNameReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDeviceName.GetDeviceNameReq = TGetDeviceNameReq

---@class FrudataIpmiCmds.GetDeviceNameRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDeviceNameRsp = {}
TGetDeviceNameRsp.__index = TGetDeviceNameRsp
TGetDeviceNameRsp.group = {}

local function TGetDeviceNameRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceNameRsp)
end

function TGetDeviceNameRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDeviceNameRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetDeviceNameRsp
function TGetDeviceNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDeviceNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceNameRsp.group)
end

TGetDeviceNameRsp.from_obj = TGetDeviceNameRsp_from_obj

TGetDeviceNameRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDeviceNameRsp.default = {0, 0, 0, ''}

TGetDeviceNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDeviceNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDeviceNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceNameRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDeviceName.GetDeviceNameRsp = TGetDeviceNameRsp

return GetDeviceName
