--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceFruid = {}

---@class FrudataIpmiCmds.GetDeviceFruidReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDeviceFruidReq = {}
TGetDeviceFruidReq.__index = TGetDeviceFruidReq
TGetDeviceFruidReq.group = {}

local function TGetDeviceFruidReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceFruidReq)
end

function TGetDeviceFruidReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetDeviceFruidReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetDeviceFruidReq
function TGetDeviceFruidReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDeviceFruidReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceFruidReq.group)
end

TGetDeviceFruidReq.from_obj = TGetDeviceFruidReq_from_obj

TGetDeviceFruidReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDeviceFruidReq.default = {0, 0, 0, 0, 0}

TGetDeviceFruidReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceFruidReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceFruidReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceFruidReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceFruidReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDeviceFruid.GetDeviceFruidReq = TGetDeviceFruidReq

---@class FrudataIpmiCmds.GetDeviceFruidRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDeviceFruidRsp = {}
TGetDeviceFruidRsp.__index = TGetDeviceFruidRsp
TGetDeviceFruidRsp.group = {}

local function TGetDeviceFruidRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceFruidRsp)
end

function TGetDeviceFruidRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDeviceFruidRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetDeviceFruidRsp
function TGetDeviceFruidRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDeviceFruidRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceFruidRsp.group)
end

TGetDeviceFruidRsp.from_obj = TGetDeviceFruidRsp_from_obj

TGetDeviceFruidRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDeviceFruidRsp.default = {0, 0, 0, ''}

TGetDeviceFruidRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDeviceFruidRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDeviceFruidRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceFruidRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceFruidRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDeviceFruid.GetDeviceFruidRsp = TGetDeviceFruidRsp

return GetDeviceFruid
