-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MFruData = {}

---@class MFruData.FruAreaSizeBytes
---@field FruAreaSizeBytes integer
local TFruAreaSizeBytes = {}
TFruAreaSizeBytes.__index = TFruAreaSizeBytes
TFruAreaSizeBytes.group = {}

local function TFruAreaSizeBytes_from_obj(obj)
    return setmetatable(obj, TFruAreaSizeBytes)
end

function TFruAreaSizeBytes.new(FruAreaSizeBytes)
    return TFruAreaSizeBytes_from_obj({FruAreaSizeBytes = FruAreaSizeBytes or 2048})
end
---@param obj MFruData.FruAreaSizeBytes
function TFruAreaSizeBytes:init_from_obj(obj)
    self.FruAreaSizeBytes = obj.FruAreaSizeBytes or 2048
end

function TFruAreaSizeBytes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruAreaSizeBytes.group)
end

TFruAreaSizeBytes.from_obj = TFruAreaSizeBytes_from_obj

TFruAreaSizeBytes.proto_property = {'FruAreaSizeBytes'}

TFruAreaSizeBytes.default = {0}

TFruAreaSizeBytes.struct = {{name = 'FruAreaSizeBytes', is_array = false, struct = nil}}

function TFruAreaSizeBytes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruAreaSizeBytes', self.FruAreaSizeBytes, 'uint16', false, errs, need_convert)

    TFruAreaSizeBytes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruAreaSizeBytes.proto_property, errs, need_convert)
    return self
end

function TFruAreaSizeBytes:unpack(_)
    return self.FruAreaSizeBytes
end

MFruData.FruAreaSizeBytes = TFruAreaSizeBytes

---@class MFruData.StorageLoc
---@field StorageLoc string
local TStorageLoc = {}
TStorageLoc.__index = TStorageLoc
TStorageLoc.group = {}

local function TStorageLoc_from_obj(obj)
    return setmetatable(obj, TStorageLoc)
end

function TStorageLoc.new(StorageLoc)
    return TStorageLoc_from_obj({StorageLoc = StorageLoc})
end
---@param obj MFruData.StorageLoc
function TStorageLoc:init_from_obj(obj)
    self.StorageLoc = obj.StorageLoc
end

function TStorageLoc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStorageLoc.group)
end

TStorageLoc.from_obj = TStorageLoc_from_obj

TStorageLoc.proto_property = {'StorageLoc'}

TStorageLoc.default = {''}

TStorageLoc.struct = {{name = 'StorageLoc', is_array = false, struct = nil}}

function TStorageLoc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StorageLoc', self.StorageLoc, 'string', false, errs, need_convert)

    TStorageLoc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStorageLoc.proto_property, errs, need_convert)
    return self
end

function TStorageLoc:unpack(_)
    return self.StorageLoc
end

MFruData.StorageLoc = TStorageLoc

---@class MFruData.StorageType
---@field StorageType string
local TStorageType = {}
TStorageType.__index = TStorageType
TStorageType.group = {}

local function TStorageType_from_obj(obj)
    return setmetatable(obj, TStorageType)
end

function TStorageType.new(StorageType)
    return TStorageType_from_obj({StorageType = StorageType})
end
---@param obj MFruData.StorageType
function TStorageType:init_from_obj(obj)
    self.StorageType = obj.StorageType
end

function TStorageType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStorageType.group)
end

TStorageType.from_obj = TStorageType_from_obj

TStorageType.proto_property = {'StorageType'}

TStorageType.default = {''}

TStorageType.struct = {{name = 'StorageType', is_array = false, struct = nil}}

function TStorageType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StorageType', self.StorageType, 'string', false, errs, need_convert)

    TStorageType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStorageType.proto_property, errs, need_convert)
    return self
end

function TStorageType:unpack(_)
    return self.StorageType
end

MFruData.StorageType = TStorageType

---@class MFruData.EepromWp
---@field EepromWp integer
local TEepromWp = {}
TEepromWp.__index = TEepromWp
TEepromWp.group = {}

local function TEepromWp_from_obj(obj)
    return setmetatable(obj, TEepromWp)
end

function TEepromWp.new(EepromWp)
    return TEepromWp_from_obj({EepromWp = EepromWp})
end
---@param obj MFruData.EepromWp
function TEepromWp:init_from_obj(obj)
    self.EepromWp = obj.EepromWp
end

function TEepromWp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEepromWp.group)
end

TEepromWp.from_obj = TEepromWp_from_obj

TEepromWp.proto_property = {'EepromWp'}

TEepromWp.default = {0}

TEepromWp.struct = {{name = 'EepromWp', is_array = false, struct = nil}}

function TEepromWp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EepromWp', self.EepromWp, 'uint8', false, errs, need_convert)

    TEepromWp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEepromWp.proto_property, errs, need_convert)
    return self
end

function TEepromWp:unpack(_)
    return self.EepromWp
end

MFruData.EepromWp = TEepromWp

---@class MFruData.FruDev
---@field FruDev integer[]
local TFruDev = {}
TFruDev.__index = TFruDev
TFruDev.group = {}

local function TFruDev_from_obj(obj)
    return setmetatable(obj, TFruDev)
end

function TFruDev.new(FruDev)
    return TFruDev_from_obj({FruDev = FruDev})
end
---@param obj MFruData.FruDev
function TFruDev:init_from_obj(obj)
    self.FruDev = obj.FruDev
end

function TFruDev:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruDev.group)
end

TFruDev.from_obj = TFruDev_from_obj

TFruDev.proto_property = {'FruDev'}

TFruDev.default = {{}}

TFruDev.struct = {{name = 'FruDev', is_array = true, struct = nil}}

function TFruDev:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FruDev', self.FruDev, 'uint8', false, errs, need_convert)

    TFruDev:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruDev.proto_property, errs, need_convert)
    return self
end

function TFruDev:unpack(_)
    return self.FruDev
end

MFruData.FruDev = TFruDev

return MFruData
