-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local context = require 'mc.context'
local log = require 'mc.logging'

local utils_core = require 'utils.core'

local M = {}

function M.record_prop_change_operation_log(system_id, msg)
    local ctx = context.get_context_or_default()
    if ctx and not ctx:is_empty() then
        log:system(system_id):operation(ctx:get_initiator(), 'fructrl', msg)
    end
end

function M.uptime()
    local ret, uptime = pcall(utils_core.get_bmc_uptime)
    if not ret then
        return 'unknown'
    end
    return uptime .. 's'
end

function M.print_host_info(system_id)
    if not system_id then
        return ''
    end
    return '[System:' .. system_id .. ']'
end

return M