-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 清除告警锁存信号

local log = require 'mc.logging'
local class = require 'mc.class'
local utils = require 'types.utils'

local c_record_fault = class()

function c_record_fault:ctor(id)
    self.objs = {}
    self.system_id = id
    log:notice_easy("[System:%s]set record_fault object successfully, uptime: %s.", id, utils.uptime())
end

function c_record_fault:insert_object(obj)
    log:notice_easy("[System:%s]insert into record_fault object successfully, uptime: %s.", self.system_id,
        utils.uptime())
    table.insert(self.objs, obj)
end

function c_record_fault:clear_record_fault()
    local ok, err
    log:notice_easy('[System:%s]Start to clear record fault......', self.system_id)
    for _, obj in pairs(self.objs) do
        ok, err = pcall(function ()
            obj.IssueRecoredAcc = 0
            obj.LatchRecoredAcc = 0
        end)
        if not ok then
            log:error('[System:%s]clear record fault failed, err:%s', self.system_id, err)
        end
    end
end

return c_record_fault