-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 链式队列，即可以删除中间元素的队列

local chain_queue = {}
chain_queue.__index = chain_queue

function chain_queue.new(cb)
    return setmetatable({
        q = {},
        cb = cb
    }, chain_queue)
end

function chain_queue:push(v)
    for i, j in pairs(self.q) do
        if self.cb(j, v) then
            self.q[i] = v
            return
        end
    end

    table.insert(self.q, v)
end

function chain_queue:pop()
    return table.remove(self.q, 1)
end

-- 删除队列中符合cb判断条件的值
function chain_queue:delete(v)
    for i, j in pairs(self.q) do
        if self.cb(j, v) then
            table.remove(self.q, i)
        end
    end
end

function chain_queue:get_len()
    return #self.q
end

return chain_queue