--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetFruActivationPolicy = {}

---@class fructrl.SetFruActivationPolicyReq
---@field FruId integer
---@field Mask integer
---@field Bit integer
local TSetFruActivationPolicyReq = {}
TSetFruActivationPolicyReq.__index = TSetFruActivationPolicyReq
TSetFruActivationPolicyReq.group = {}

local function TSetFruActivationPolicyReq_from_obj(obj)
    return setmetatable(obj, TSetFruActivationPolicyReq)
end

function TSetFruActivationPolicyReq.new(FruId, Mask, Bit)
    return TSetFruActivationPolicyReq_from_obj({FruId = FruId, Mask = Mask, Bit = Bit})
end
---@param obj fructrl.SetFruActivationPolicyReq
function TSetFruActivationPolicyReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Mask = obj.Mask
    self.Bit = obj.Bit
end

function TSetFruActivationPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFruActivationPolicyReq.group)
end

TSetFruActivationPolicyReq.from_obj = TSetFruActivationPolicyReq_from_obj

TSetFruActivationPolicyReq.proto_property = {'FruId', 'Mask', 'Bit'}

TSetFruActivationPolicyReq.default = {0, 0, 0}

TSetFruActivationPolicyReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Mask', is_array = false, struct = nil},
    {name = 'Bit', is_array = false, struct = nil}
}

function TSetFruActivationPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Mask', self.Mask, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bit', self.Bit, 'uint8', false, errs, need_convert)

    TSetFruActivationPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFruActivationPolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetFruActivationPolicyReq:unpack(_)
    return self.FruId, self.Mask, self.Bit
end

SetFruActivationPolicy.SetFruActivationPolicyReq = TSetFruActivationPolicyReq

---@class fructrl.SetFruActivationPolicyRsp
---@field CompletionCode integer
local TSetFruActivationPolicyRsp = {}
TSetFruActivationPolicyRsp.__index = TSetFruActivationPolicyRsp
TSetFruActivationPolicyRsp.group = {}

local function TSetFruActivationPolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetFruActivationPolicyRsp)
end

function TSetFruActivationPolicyRsp.new(CompletionCode)
    return TSetFruActivationPolicyRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj fructrl.SetFruActivationPolicyRsp
function TSetFruActivationPolicyRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetFruActivationPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFruActivationPolicyRsp.group)
end

TSetFruActivationPolicyRsp.from_obj = TSetFruActivationPolicyRsp_from_obj

TSetFruActivationPolicyRsp.proto_property = {'CompletionCode'}

TSetFruActivationPolicyRsp.default = {0}

TSetFruActivationPolicyRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetFruActivationPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetFruActivationPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFruActivationPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetFruActivationPolicyRsp:unpack(_)
    return self.CompletionCode
end

SetFruActivationPolicy.SetFruActivationPolicyRsp = TSetFruActivationPolicyRsp

return SetFruActivationPolicy
