--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetACPIPowerState = {}

---@class fructrl.GetACPIPowerStateReq
local TGetACPIPowerStateReq = {}
TGetACPIPowerStateReq.__index = TGetACPIPowerStateReq
TGetACPIPowerStateReq.group = {}

local function TGetACPIPowerStateReq_from_obj(obj)
    return setmetatable(obj, TGetACPIPowerStateReq)
end

function TGetACPIPowerStateReq.new()
    return TGetACPIPowerStateReq_from_obj({})
end
---@param obj fructrl.GetACPIPowerStateReq
function TGetACPIPowerStateReq:init_from_obj(obj)

end

function TGetACPIPowerStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetACPIPowerStateReq.group)
end

TGetACPIPowerStateReq.from_obj = TGetACPIPowerStateReq_from_obj

TGetACPIPowerStateReq.proto_property = {}

TGetACPIPowerStateReq.default = {}

TGetACPIPowerStateReq.struct = {}

function TGetACPIPowerStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetACPIPowerStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetACPIPowerStateReq.proto_property, errs, need_convert)
    return self
end

function TGetACPIPowerStateReq:unpack(_)
end

GetACPIPowerState.GetACPIPowerStateReq = TGetACPIPowerStateReq

---@class fructrl.GetACPIPowerStateRsp
---@field CompletionCode integer
---@field ACPISystemPowerState integer
---@field ACPIDevicePowerState integer
local TGetACPIPowerStateRsp = {}
TGetACPIPowerStateRsp.__index = TGetACPIPowerStateRsp
TGetACPIPowerStateRsp.group = {}

local function TGetACPIPowerStateRsp_from_obj(obj)
    return setmetatable(obj, TGetACPIPowerStateRsp)
end

function TGetACPIPowerStateRsp.new(CompletionCode, ACPISystemPowerState, ACPIDevicePowerState)
    return TGetACPIPowerStateRsp_from_obj({
        CompletionCode = CompletionCode,
        ACPISystemPowerState = ACPISystemPowerState,
        ACPIDevicePowerState = ACPIDevicePowerState
    })
end
---@param obj fructrl.GetACPIPowerStateRsp
function TGetACPIPowerStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ACPISystemPowerState = obj.ACPISystemPowerState
    self.ACPIDevicePowerState = obj.ACPIDevicePowerState
end

function TGetACPIPowerStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetACPIPowerStateRsp.group)
end

TGetACPIPowerStateRsp.from_obj = TGetACPIPowerStateRsp_from_obj

TGetACPIPowerStateRsp.proto_property = {'CompletionCode', 'ACPISystemPowerState', 'ACPIDevicePowerState'}

TGetACPIPowerStateRsp.default = {0, 0, 0}

TGetACPIPowerStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ACPISystemPowerState', is_array = false, struct = nil},
    {name = 'ACPIDevicePowerState', is_array = false, struct = nil}
}

function TGetACPIPowerStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ACPISystemPowerState', self.ACPISystemPowerState, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ACPIDevicePowerState', self.ACPIDevicePowerState, 'uint8', false, errs, need_convert)

    TGetACPIPowerStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetACPIPowerStateRsp.proto_property, errs, need_convert)
    return self
end

function TGetACPIPowerStateRsp:unpack(_)
    return self.CompletionCode, self.ACPISystemPowerState, self.ACPIDevicePowerState
end

GetACPIPowerState.GetACPIPowerStateRsp = TGetACPIPowerStateRsp

return GetACPIPowerState
