--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetACLostStatus = {}

---@class fructrl.GetACLostStatusReq
---@field ManufactureId integer
local TGetACLostStatusReq = {}
TGetACLostStatusReq.__index = TGetACLostStatusReq
TGetACLostStatusReq.group = {}

local function TGetACLostStatusReq_from_obj(obj)
    return setmetatable(obj, TGetACLostStatusReq)
end

function TGetACLostStatusReq.new(ManufactureId)
    return TGetACLostStatusReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj fructrl.GetACLostStatusReq
function TGetACLostStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetACLostStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetACLostStatusReq.group)
end

TGetACLostStatusReq.from_obj = TGetACLostStatusReq_from_obj

TGetACLostStatusReq.proto_property = {'ManufactureId'}

TGetACLostStatusReq.default = {0}

TGetACLostStatusReq.struct = {{name = 'ManufactureId', is_array = false, struct = nil}}

function TGetACLostStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TGetACLostStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetACLostStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetACLostStatusReq:unpack(_)
    return self.ManufactureId
end

GetACLostStatus.GetACLostStatusReq = TGetACLostStatusReq

---@class fructrl.GetACLostStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Status integer
local TGetACLostStatusRsp = {}
TGetACLostStatusRsp.__index = TGetACLostStatusRsp
TGetACLostStatusRsp.group = {}

local function TGetACLostStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetACLostStatusRsp)
end

function TGetACLostStatusRsp.new(CompletionCode, ManufactureId, Status)
    return TGetACLostStatusRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Status = Status
    })
end
---@param obj fructrl.GetACLostStatusRsp
function TGetACLostStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Status = obj.Status
end

function TGetACLostStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetACLostStatusRsp.group)
end

TGetACLostStatusRsp.from_obj = TGetACLostStatusRsp_from_obj

TGetACLostStatusRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Status'}

TGetACLostStatusRsp.default = {0, 0, 0}

TGetACLostStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Status', is_array = false, struct = nil}
}

function TGetACLostStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TGetACLostStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetACLostStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetACLostStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Status
end

GetACLostStatus.GetACLostStatusRsp = TGetACLostStatusRsp

return GetACLostStatus
