--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local CmdFruCtrl = {}

---@class fructrl.CmdFruCtrlReq
---@field FruId integer
---@field Option integer
local TCmdFruCtrlReq = {}
TCmdFruCtrlReq.__index = TCmdFruCtrlReq
TCmdFruCtrlReq.group = {}

local function TCmdFruCtrlReq_from_obj(obj)
    return setmetatable(obj, TCmdFruCtrlReq)
end

function TCmdFruCtrlReq.new(FruId, Option)
    return TCmdFruCtrlReq_from_obj({FruId = FruId, Option = Option})
end
---@param obj fructrl.CmdFruCtrlReq
function TCmdFruCtrlReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Option = obj.Option
end

function TCmdFruCtrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCmdFruCtrlReq.group)
end

TCmdFruCtrlReq.from_obj = TCmdFruCtrlReq_from_obj

TCmdFruCtrlReq.proto_property = {'FruId', 'Option'}

TCmdFruCtrlReq.default = {0, 0}

TCmdFruCtrlReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Option', is_array = false, struct = nil}
}

function TCmdFruCtrlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Option', self.Option, 'uint8', false, errs, need_convert)

    TCmdFruCtrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCmdFruCtrlReq.proto_property, errs, need_convert)
    return self
end

function TCmdFruCtrlReq:unpack(_)
    return self.FruId, self.Option
end

CmdFruCtrl.CmdFruCtrlReq = TCmdFruCtrlReq

---@class fructrl.CmdFruCtrlRsp
---@field CompletionCode integer
local TCmdFruCtrlRsp = {}
TCmdFruCtrlRsp.__index = TCmdFruCtrlRsp
TCmdFruCtrlRsp.group = {}

local function TCmdFruCtrlRsp_from_obj(obj)
    return setmetatable(obj, TCmdFruCtrlRsp)
end

function TCmdFruCtrlRsp.new(CompletionCode)
    return TCmdFruCtrlRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj fructrl.CmdFruCtrlRsp
function TCmdFruCtrlRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TCmdFruCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCmdFruCtrlRsp.group)
end

TCmdFruCtrlRsp.from_obj = TCmdFruCtrlRsp_from_obj

TCmdFruCtrlRsp.proto_property = {'CompletionCode'}

TCmdFruCtrlRsp.default = {0}

TCmdFruCtrlRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TCmdFruCtrlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TCmdFruCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCmdFruCtrlRsp.proto_property, errs, need_convert)
    return self
end

function TCmdFruCtrlRsp:unpack(_)
    return self.CompletionCode
end

CmdFruCtrl.CmdFruCtrlRsp = TCmdFruCtrlRsp

return CmdFruCtrl
