-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = {}

---@class def_types.PwrOnLockedRecord
---@field appname string
---@field reason string
---@field pwronlocked boolean
---@field timeout integer
local TPwrOnLockedRecord = {}
TPwrOnLockedRecord.__index = TPwrOnLockedRecord
TPwrOnLockedRecord.group = {}

local function TPwrOnLockedRecord_from_obj(obj)
    return setmetatable(obj, TPwrOnLockedRecord)
end

function TPwrOnLockedRecord.new(appname, reason, pwronlocked, timeout)
    return TPwrOnLockedRecord_from_obj({
        appname = appname,
        reason = reason,
        pwronlocked = pwronlocked,
        timeout = timeout
    })
end
---@param obj def_types.PwrOnLockedRecord
function TPwrOnLockedRecord:init_from_obj(obj)
    self.appname = obj.appname
    self.reason = obj.reason
    self.pwronlocked = obj.pwronlocked
    self.timeout = obj.timeout
end

function TPwrOnLockedRecord:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPwrOnLockedRecord.group)
end

TPwrOnLockedRecord.from_obj = TPwrOnLockedRecord_from_obj

TPwrOnLockedRecord.proto_property = {'appname', 'reason', 'pwronlocked', 'timeout'}

TPwrOnLockedRecord.default = {'', '', false, 0}

TPwrOnLockedRecord.struct = {
    {name = 'appname', is_array = false, struct = nil}, {name = 'reason', is_array = false, struct = nil},
    {name = 'pwronlocked', is_array = false, struct = nil}, {name = 'timeout', is_array = false, struct = nil}
}

function TPwrOnLockedRecord:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'appname', self.appname, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'reason', self.reason, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'pwronlocked', self.pwronlocked, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'timeout', self.timeout, 'uint32', false, errs, need_convert)

    TPwrOnLockedRecord:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPwrOnLockedRecord.proto_property, errs, need_convert)
    return self
end

function TPwrOnLockedRecord:unpack(_)
    return self.appname, self.reason, self.pwronlocked, self.timeout
end

def_types.PwrOnLockedRecord = TPwrOnLockedRecord

return def_types
