-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MRecordFault = {}

---@class MRecordFault.IsValid
---@field IsValid boolean
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj)
    return setmetatable(obj, TIsValid)
end

function TIsValid.new(IsValid)
    return TIsValid_from_obj({IsValid = IsValid == nil and true or IsValid})
end
---@param obj MRecordFault.IsValid
function TIsValid:init_from_obj(obj)
    self.IsValid = obj.IsValid == nil and true or obj.IsValid
end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {false}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, 'bool', false, errs, need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs, need_convert)
    return self
end

function TIsValid:unpack(_)
    return self.IsValid
end

MRecordFault.IsValid = TIsValid

---@class MRecordFault.LatchRecoredAcc
---@field LatchRecoredAcc integer
local TLatchRecoredAcc = {}
TLatchRecoredAcc.__index = TLatchRecoredAcc
TLatchRecoredAcc.group = {}

local function TLatchRecoredAcc_from_obj(obj)
    return setmetatable(obj, TLatchRecoredAcc)
end

function TLatchRecoredAcc.new(LatchRecoredAcc)
    return TLatchRecoredAcc_from_obj({LatchRecoredAcc = LatchRecoredAcc})
end
---@param obj MRecordFault.LatchRecoredAcc
function TLatchRecoredAcc:init_from_obj(obj)
    self.LatchRecoredAcc = obj.LatchRecoredAcc
end

function TLatchRecoredAcc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLatchRecoredAcc.group)
end

TLatchRecoredAcc.from_obj = TLatchRecoredAcc_from_obj

TLatchRecoredAcc.proto_property = {'LatchRecoredAcc'}

TLatchRecoredAcc.default = {0}

TLatchRecoredAcc.struct = {{name = 'LatchRecoredAcc', is_array = false, struct = nil}}

function TLatchRecoredAcc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LatchRecoredAcc', self.LatchRecoredAcc, 'uint8', false, errs, need_convert)

    TLatchRecoredAcc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLatchRecoredAcc.proto_property, errs, need_convert)
    return self
end

function TLatchRecoredAcc:unpack(_)
    return self.LatchRecoredAcc
end

MRecordFault.LatchRecoredAcc = TLatchRecoredAcc

---@class MRecordFault.IssueRecoredAcc
---@field IssueRecoredAcc integer
local TIssueRecoredAcc = {}
TIssueRecoredAcc.__index = TIssueRecoredAcc
TIssueRecoredAcc.group = {}

local function TIssueRecoredAcc_from_obj(obj)
    return setmetatable(obj, TIssueRecoredAcc)
end

function TIssueRecoredAcc.new(IssueRecoredAcc)
    return TIssueRecoredAcc_from_obj({IssueRecoredAcc = IssueRecoredAcc})
end
---@param obj MRecordFault.IssueRecoredAcc
function TIssueRecoredAcc:init_from_obj(obj)
    self.IssueRecoredAcc = obj.IssueRecoredAcc
end

function TIssueRecoredAcc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIssueRecoredAcc.group)
end

TIssueRecoredAcc.from_obj = TIssueRecoredAcc_from_obj

TIssueRecoredAcc.proto_property = {'IssueRecoredAcc'}

TIssueRecoredAcc.default = {0}

TIssueRecoredAcc.struct = {{name = 'IssueRecoredAcc', is_array = false, struct = nil}}

function TIssueRecoredAcc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IssueRecoredAcc', self.IssueRecoredAcc, 'uint8', false, errs, need_convert)

    TIssueRecoredAcc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIssueRecoredAcc.proto_property, errs, need_convert)
    return self
end

function TIssueRecoredAcc:unpack(_)
    return self.IssueRecoredAcc
end

MRecordFault.IssueRecoredAcc = TIssueRecoredAcc

---@class MRecordFault.FruID
---@field FruID integer
local TFruID = {}
TFruID.__index = TFruID
TFruID.group = {}

local function TFruID_from_obj(obj)
    return setmetatable(obj, TFruID)
end

function TFruID.new(FruID)
    return TFruID_from_obj({FruID = FruID or 0})
end
---@param obj MRecordFault.FruID
function TFruID:init_from_obj(obj)
    self.FruID = obj.FruID or 0
end

function TFruID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruID.group)
end

TFruID.from_obj = TFruID_from_obj

TFruID.proto_property = {'FruID'}

TFruID.default = {0}

TFruID.struct = {{name = 'FruID', is_array = false, struct = nil}}

function TFruID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruID', self.FruID, 'uint8', false, errs, need_convert)

    TFruID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruID.proto_property, errs, need_convert)
    return self
end

function TFruID:unpack(_)
    return self.FruID
end

MRecordFault.FruID = TFruID

return MRecordFault
