-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MFruCtrl = {}

---@class MFruCtrl.ACPIDevicePowerState
---@field ACPIDevicePowerState string
local TACPIDevicePowerState = {}
TACPIDevicePowerState.__index = TACPIDevicePowerState
TACPIDevicePowerState.group = {}

local function TACPIDevicePowerState_from_obj(obj)
    return setmetatable(obj, TACPIDevicePowerState)
end

function TACPIDevicePowerState.new(ACPIDevicePowerState)
    return TACPIDevicePowerState_from_obj({ACPIDevicePowerState = ACPIDevicePowerState or [=[]=]})
end
---@param obj MFruCtrl.ACPIDevicePowerState
function TACPIDevicePowerState:init_from_obj(obj)
    self.ACPIDevicePowerState = obj.ACPIDevicePowerState or [=[]=]
end

function TACPIDevicePowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TACPIDevicePowerState.group)
end

TACPIDevicePowerState.from_obj = TACPIDevicePowerState_from_obj

TACPIDevicePowerState.proto_property = {'ACPIDevicePowerState'}

TACPIDevicePowerState.default = {''}

TACPIDevicePowerState.struct = {{name = 'ACPIDevicePowerState', is_array = false, struct = nil}}

function TACPIDevicePowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ACPIDevicePowerState', self.ACPIDevicePowerState, 'string', false, errs, need_convert)

    TACPIDevicePowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TACPIDevicePowerState.proto_property, errs, need_convert)
    return self
end

function TACPIDevicePowerState:unpack(_)
    return self.ACPIDevicePowerState
end

MFruCtrl.ACPIDevicePowerState = TACPIDevicePowerState

---@class MFruCtrl.ACPISystemPowerState
---@field ACPISystemPowerState string
local TACPISystemPowerState = {}
TACPISystemPowerState.__index = TACPISystemPowerState
TACPISystemPowerState.group = {}

local function TACPISystemPowerState_from_obj(obj)
    return setmetatable(obj, TACPISystemPowerState)
end

function TACPISystemPowerState.new(ACPISystemPowerState)
    return TACPISystemPowerState_from_obj({ACPISystemPowerState = ACPISystemPowerState or [=[]=]})
end
---@param obj MFruCtrl.ACPISystemPowerState
function TACPISystemPowerState:init_from_obj(obj)
    self.ACPISystemPowerState = obj.ACPISystemPowerState or [=[]=]
end

function TACPISystemPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TACPISystemPowerState.group)
end

TACPISystemPowerState.from_obj = TACPISystemPowerState_from_obj

TACPISystemPowerState.proto_property = {'ACPISystemPowerState'}

TACPISystemPowerState.default = {''}

TACPISystemPowerState.struct = {{name = 'ACPISystemPowerState', is_array = false, struct = nil}}

function TACPISystemPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ACPISystemPowerState', self.ACPISystemPowerState, 'string', false, errs, need_convert)

    TACPISystemPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TACPISystemPowerState.proto_property, errs, need_convert)
    return self
end

function TACPISystemPowerState:unpack(_)
    return self.ACPISystemPowerState
end

MFruCtrl.ACPISystemPowerState = TACPISystemPowerState

---@class MFruCtrl.IsValid
---@field IsValid boolean
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj)
    return setmetatable(obj, TIsValid)
end

function TIsValid.new(IsValid)
    return TIsValid_from_obj({IsValid = IsValid == nil and true or IsValid})
end
---@param obj MFruCtrl.IsValid
function TIsValid:init_from_obj(obj)
    self.IsValid = obj.IsValid == nil and true or obj.IsValid
end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {false}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, 'bool', false, errs, need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs, need_convert)
    return self
end

function TIsValid:unpack(_)
    return self.IsValid
end

MFruCtrl.IsValid = TIsValid

---@class MFruCtrl.PowerOnTimeoutSeconds
---@field PowerOnTimeoutSeconds integer
local TPowerOnTimeoutSeconds = {}
TPowerOnTimeoutSeconds.__index = TPowerOnTimeoutSeconds
TPowerOnTimeoutSeconds.group = {}

local function TPowerOnTimeoutSeconds_from_obj(obj)
    return setmetatable(obj, TPowerOnTimeoutSeconds)
end

function TPowerOnTimeoutSeconds.new(PowerOnTimeoutSeconds)
    return TPowerOnTimeoutSeconds_from_obj({PowerOnTimeoutSeconds = PowerOnTimeoutSeconds or 10})
end
---@param obj MFruCtrl.PowerOnTimeoutSeconds
function TPowerOnTimeoutSeconds:init_from_obj(obj)
    self.PowerOnTimeoutSeconds = obj.PowerOnTimeoutSeconds or 10
end

function TPowerOnTimeoutSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOnTimeoutSeconds.group)
end

TPowerOnTimeoutSeconds.from_obj = TPowerOnTimeoutSeconds_from_obj

TPowerOnTimeoutSeconds.proto_property = {'PowerOnTimeoutSeconds'}

TPowerOnTimeoutSeconds.default = {0}

TPowerOnTimeoutSeconds.struct = {{name = 'PowerOnTimeoutSeconds', is_array = false, struct = nil}}

function TPowerOnTimeoutSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOnTimeoutSeconds', self.PowerOnTimeoutSeconds, 'uint32', false, errs, need_convert)

    TPowerOnTimeoutSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOnTimeoutSeconds.proto_property, errs, need_convert)
    return self
end

function TPowerOnTimeoutSeconds:unpack(_)
    return self.PowerOnTimeoutSeconds
end

MFruCtrl.PowerOnTimeoutSeconds = TPowerOnTimeoutSeconds

---@class MFruCtrl.PwrOnLockedRecord
---@field PwrOnLockedRecord def_types.PwrOnLockedRecord[]
local TPwrOnLockedRecord = {}
TPwrOnLockedRecord.__index = TPwrOnLockedRecord
TPwrOnLockedRecord.group = {}

local function TPwrOnLockedRecord_from_obj(obj)
    obj.PwrOnLockedRecord = utils.from_obj(def_types.PwrOnLockedRecord, obj.PwrOnLockedRecord, true)
    return setmetatable(obj, TPwrOnLockedRecord)
end

function TPwrOnLockedRecord.new(PwrOnLockedRecord)
    return TPwrOnLockedRecord_from_obj({PwrOnLockedRecord = PwrOnLockedRecord})
end
---@param obj MFruCtrl.PwrOnLockedRecord
function TPwrOnLockedRecord:init_from_obj(obj)
    self.PwrOnLockedRecord = obj.PwrOnLockedRecord
end

function TPwrOnLockedRecord:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPwrOnLockedRecord.group)
end

TPwrOnLockedRecord.from_obj = TPwrOnLockedRecord_from_obj

TPwrOnLockedRecord.proto_property = {'PwrOnLockedRecord'}

TPwrOnLockedRecord.default = {{}}

TPwrOnLockedRecord.struct = {{name = 'PwrOnLockedRecord', is_array = true, struct = def_types.PwrOnLockedRecord.struct}}

function TPwrOnLockedRecord:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.PwrOnLockedRecord) do
        def_types.PwrOnLockedRecord.new(v.appname, v.reason, v.pwronlocked, v.timeout):validate(prefix, errs,
            need_convert)
    end

    TPwrOnLockedRecord:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPwrOnLockedRecord.proto_property, errs, need_convert)
    return self
end

function TPwrOnLockedRecord:unpack(raw)
    return utils.unpack(raw, self.PwrOnLockedRecord, true)
end

MFruCtrl.PwrOnLockedRecord = TPwrOnLockedRecord

---@class MFruCtrl.PwrRestoreRecord
---@field PwrRestoreRecord string[]
local TPwrRestoreRecord = {}
TPwrRestoreRecord.__index = TPwrRestoreRecord
TPwrRestoreRecord.group = {}

local function TPwrRestoreRecord_from_obj(obj)
    return setmetatable(obj, TPwrRestoreRecord)
end

function TPwrRestoreRecord.new(PwrRestoreRecord)
    return TPwrRestoreRecord_from_obj({PwrRestoreRecord = PwrRestoreRecord})
end
---@param obj MFruCtrl.PwrRestoreRecord
function TPwrRestoreRecord:init_from_obj(obj)
    self.PwrRestoreRecord = obj.PwrRestoreRecord
end

function TPwrRestoreRecord:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPwrRestoreRecord.group)
end

TPwrRestoreRecord.from_obj = TPwrRestoreRecord_from_obj

TPwrRestoreRecord.proto_property = {'PwrRestoreRecord'}

TPwrRestoreRecord.default = {{}}

TPwrRestoreRecord.struct = {{name = 'PwrRestoreRecord', is_array = true, struct = nil}}

function TPwrRestoreRecord:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PwrRestoreRecord', self.PwrRestoreRecord, 'string', false, errs, need_convert)

    TPwrRestoreRecord:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPwrRestoreRecord.proto_property, errs, need_convert)
    return self
end

function TPwrRestoreRecord:unpack(_)
    return self.PwrRestoreRecord
end

MFruCtrl.PwrRestoreRecord = TPwrRestoreRecord

---@class MFruCtrl.BmcResetFlag
---@field BmcResetFlag integer
local TBmcResetFlag = {}
TBmcResetFlag.__index = TBmcResetFlag
TBmcResetFlag.group = {}

local function TBmcResetFlag_from_obj(obj)
    return setmetatable(obj, TBmcResetFlag)
end

function TBmcResetFlag.new(BmcResetFlag)
    return TBmcResetFlag_from_obj({BmcResetFlag = BmcResetFlag or 0})
end
---@param obj MFruCtrl.BmcResetFlag
function TBmcResetFlag:init_from_obj(obj)
    self.BmcResetFlag = obj.BmcResetFlag or 0
end

function TBmcResetFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBmcResetFlag.group)
end

TBmcResetFlag.from_obj = TBmcResetFlag_from_obj

TBmcResetFlag.proto_property = {'BmcResetFlag'}

TBmcResetFlag.default = {0}

TBmcResetFlag.struct = {{name = 'BmcResetFlag', is_array = false, struct = nil}}

function TBmcResetFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BmcResetFlag', self.BmcResetFlag, 'uint8', false, errs, need_convert)

    TBmcResetFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBmcResetFlag.proto_property, errs, need_convert)
    return self
end

function TBmcResetFlag:unpack(_)
    return self.BmcResetFlag
end

MFruCtrl.BmcResetFlag = TBmcResetFlag

---@class MFruCtrl.PwrStateBeforeACLost
---@field PwrStateBeforeACLost boolean
local TPwrStateBeforeACLost = {}
TPwrStateBeforeACLost.__index = TPwrStateBeforeACLost
TPwrStateBeforeACLost.group = {}

local function TPwrStateBeforeACLost_from_obj(obj)
    return setmetatable(obj, TPwrStateBeforeACLost)
end

function TPwrStateBeforeACLost.new(PwrStateBeforeACLost)
    return TPwrStateBeforeACLost_from_obj({PwrStateBeforeACLost = PwrStateBeforeACLost})
end
---@param obj MFruCtrl.PwrStateBeforeACLost
function TPwrStateBeforeACLost:init_from_obj(obj)
    self.PwrStateBeforeACLost = obj.PwrStateBeforeACLost
end

function TPwrStateBeforeACLost:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPwrStateBeforeACLost.group)
end

TPwrStateBeforeACLost.from_obj = TPwrStateBeforeACLost_from_obj

TPwrStateBeforeACLost.proto_property = {'PwrStateBeforeACLost'}

TPwrStateBeforeACLost.default = {false}

TPwrStateBeforeACLost.struct = {{name = 'PwrStateBeforeACLost', is_array = false, struct = nil}}

function TPwrStateBeforeACLost:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PwrStateBeforeACLost', self.PwrStateBeforeACLost, 'bool', false, errs, need_convert)

    TPwrStateBeforeACLost:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPwrStateBeforeACLost.proto_property, errs, need_convert)
    return self
end

function TPwrStateBeforeACLost:unpack(_)
    return self.PwrStateBeforeACLost
end

MFruCtrl.PwrStateBeforeACLost = TPwrStateBeforeACLost

---@class MFruCtrl.PwrCycleDelaySeconds
---@field PwrCycleDelaySeconds integer
local TPwrCycleDelaySeconds = {}
TPwrCycleDelaySeconds.__index = TPwrCycleDelaySeconds
TPwrCycleDelaySeconds.group = {}

local function TPwrCycleDelaySeconds_from_obj(obj)
    return setmetatable(obj, TPwrCycleDelaySeconds)
end

function TPwrCycleDelaySeconds.new(PwrCycleDelaySeconds)
    return TPwrCycleDelaySeconds_from_obj({PwrCycleDelaySeconds = PwrCycleDelaySeconds or 10})
end
---@param obj MFruCtrl.PwrCycleDelaySeconds
function TPwrCycleDelaySeconds:init_from_obj(obj)
    self.PwrCycleDelaySeconds = obj.PwrCycleDelaySeconds or 10
end

function TPwrCycleDelaySeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPwrCycleDelaySeconds.group)
end

TPwrCycleDelaySeconds.from_obj = TPwrCycleDelaySeconds_from_obj

TPwrCycleDelaySeconds.proto_property = {'PwrCycleDelaySeconds'}

TPwrCycleDelaySeconds.default = {0}

TPwrCycleDelaySeconds.struct = {{name = 'PwrCycleDelaySeconds', is_array = false, struct = nil}}

function TPwrCycleDelaySeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PwrCycleDelaySeconds', self.PwrCycleDelaySeconds, 'uint32', false, errs, need_convert)

    TPwrCycleDelaySeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPwrCycleDelaySeconds.proto_property, errs, need_convert)
    return self
end

function TPwrCycleDelaySeconds:unpack(_)
    return self.PwrCycleDelaySeconds
end

MFruCtrl.PwrCycleDelaySeconds = TPwrCycleDelaySeconds

---@class MFruCtrl.FruID
---@field FruID integer
local TFruID = {}
TFruID.__index = TFruID
TFruID.group = {}

local function TFruID_from_obj(obj)
    return setmetatable(obj, TFruID)
end

function TFruID.new(FruID)
    return TFruID_from_obj({FruID = FruID or 0})
end
---@param obj MFruCtrl.FruID
function TFruID:init_from_obj(obj)
    self.FruID = obj.FruID or 0
end

function TFruID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruID.group)
end

TFruID.from_obj = TFruID_from_obj

TFruID.proto_property = {'FruID'}

TFruID.default = {0}

TFruID.struct = {{name = 'FruID', is_array = false, struct = nil}}

function TFruID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruID', self.FruID, 'uint8', false, errs, need_convert)

    TFruID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruID.proto_property, errs, need_convert)
    return self
end

function TFruID:unpack(_)
    return self.FruID
end

MFruCtrl.FruID = TFruID

---@class MFruCtrl.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MFruCtrl.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MFruCtrl.Id = TId

return MFruCtrl
