-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local led_object = require 'led_object'

TestUIDLedServcie = {}

function TestUIDLedServcie:test_set_uid_led()
    -- 测试state为0时 关闭状态
    local on_duration, off_duration = led_object:get_onoffduration_by_state(0)
    lu.assertEquals(on_duration, 0)
    lu.assertEquals(off_duration, 0)
    -- 当state为5时 闪烁状态
    on_duration, off_duration = led_object:get_onoffduration_by_state(5)
    lu.assertEquals(on_duration, 50)
    lu.assertEquals(off_duration, 50)
    -- 测试当state为255时 点亮状态
    on_duration, off_duration = led_object:get_onoffduration_by_state(255)
    lu.assertEquals(on_duration, 255)
    lu.assertEquals(off_duration, 0)
end
