-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 装备测试集成测试用例
local lu = require 'luaunit'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local context = require 'mc.context'
local skynet = require 'skynet'

require 'chassis.json_types.Manufacture'
local test_dft = {}

local DFT_CHASSIS_COVER_PATH <const> =
'/bmc/kepler/Manufacture/OperateTest/DftChassisCover/DftChassisCover_1_010101'
local DFT_CHASSIS_COVER_INTERFACE = 'bmc.kepler.Manufacture'

local DFT_BUTTON_TEST_PATH <const> =
'/bmc/kepler/Manufacture/OperateTest/DftButtonTest/DftButtonTest_0101'
local DFT_BUTTON_TEST_INTERFACE = 'bmc.kepler.Manufacture'

-- 测试装备项 DftChassis
local function test_dft_chassis_over(bus)
    local obj = mdb.get_object(bus, DFT_CHASSIS_COVER_PATH, DFT_CHASSIS_COVER_INTERFACE)
    lu.assertEquals(obj.Slot, 0)
    obj:Start_PACKED(context.new())
    obj:Stop_PACKED(context.new())
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    log:info('test dft chassis cover finish')
end

--  测试项装备 DftButtonTest
local function test_dft_button_test(bus)
    local obj = mdb.get_object(bus, DFT_BUTTON_TEST_PATH, DFT_BUTTON_TEST_INTERFACE)
    lu.assertEquals(obj.Slot, 3)
    obj:Start_PACKED(context.new())
    obj:Stop_PACKED(context.new())
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Non")
    log:info('test dft button test finish')
end
 

function test_dft.test_all_dft_method(bus)
    skynet.sleep(200)
    test_dft_chassis_over(bus)
    test_dft_button_test(bus)
end

return test_dft
