-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local skynet = require 'skynet'
require 'skynet.manager'
local logging = require 'mc.logging'
local chassis_app = require 'chassis_app'

local function change_debuglog_path(option)
    if not option then
        return
    end
    logging:setLevel(logging.DEBUG)
    logging.info = function(self, fmt, ...)
        skynet.error('INFO', string.format(fmt, ...))
    end
    logging.notice = function(self, fmt, ...)
        skynet.error('NOTICE', string.format(fmt, ...))
    end
    logging.error = function(self, fmt, ...)
        skynet.error('ERROR', string.format(fmt, ...))
    end
    logging.debug = function(self, fmt, ...)
    end
end

change_debuglog_path(false)

local CMD = {}
local app

function CMD.exit()
    logging:info('chassis service exit')
end

skynet.start(function()
    skynet.uniqueservice('sd_bus')
    skynet.register('chassis')
    app = chassis_app.new()
    local ok, handler = pcall(require, 'manufacture_chassis_app')
    if ok then
        local manufacture = handler.new(app)
        manufacture:init()
    end
    skynet.dispatch('lua', function(_, _, cmd, ...)
        local f = assert(CMD[cmd])
        skynet.ret(skynet.pack(f(...)))
    end)
end)
