-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MI2cLed = {}

---@class MI2cLed.LedOnValue
---@field LedOnValue integer
local TLedOnValue = {}
TLedOnValue.__index = TLedOnValue
TLedOnValue.group = {}

local function TLedOnValue_from_obj(obj)
    return setmetatable(obj, TLedOnValue)
end

function TLedOnValue.new(LedOnValue)
    return TLedOnValue_from_obj({LedOnValue = LedOnValue})
end
---@param obj MI2cLed.LedOnValue
function TLedOnValue:init_from_obj(obj)
    self.LedOnValue = obj.LedOnValue
end

function TLedOnValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLedOnValue.group)
end

TLedOnValue.from_obj = TLedOnValue_from_obj

TLedOnValue.proto_property = {'LedOnValue'}

TLedOnValue.default = {0}

TLedOnValue.struct = {{name = 'LedOnValue', is_array = false, struct = nil}}

function TLedOnValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LedOnValue', self.LedOnValue, 'uint8', false, errs, need_convert)

    TLedOnValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLedOnValue.proto_property, errs, need_convert)
    return self
end

function TLedOnValue:unpack(_)
    return self.LedOnValue
end

MI2cLed.LedOnValue = TLedOnValue

---@class MI2cLed.CtrlValue
---@field CtrlValue integer
local TCtrlValue = {}
TCtrlValue.__index = TCtrlValue
TCtrlValue.group = {}

local function TCtrlValue_from_obj(obj)
    return setmetatable(obj, TCtrlValue)
end

function TCtrlValue.new(CtrlValue)
    return TCtrlValue_from_obj({CtrlValue = CtrlValue})
end
---@param obj MI2cLed.CtrlValue
function TCtrlValue:init_from_obj(obj)
    self.CtrlValue = obj.CtrlValue
end

function TCtrlValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlValue.group)
end

TCtrlValue.from_obj = TCtrlValue_from_obj

TCtrlValue.proto_property = {'CtrlValue'}

TCtrlValue.default = {0}

TCtrlValue.struct = {{name = 'CtrlValue', is_array = false, struct = nil}}

function TCtrlValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlValue', self.CtrlValue, 'uint8', false, errs, need_convert)

    TCtrlValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlValue.proto_property, errs, need_convert)
    return self
end

function TCtrlValue:unpack(_)
    return self.CtrlValue
end

MI2cLed.CtrlValue = TCtrlValue

return MI2cLed
