-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local led_policy_class_types = require 'class.types.LedPolicy'
local led_class_types = require 'class.types.Led'
local chassis_class_types = require 'class.types.Chassis'
local led_disp_control_class_types = require 'class.types.LedDispControl'
local i2c_led_class_types = require 'class.types.I2cLed'
local dft_pysical_led_class_types = require 'class.types.DftPysicalLed'
local dft_led_intelligence_class_types = require 'class.types.DftLedIntelligence'
local chassis_table_class_types = require 'class.types.ChassisTable'
local super_pod_label_class_types = require 'class.types.SuperPodLabel'
local dft_button_test_class_types = require 'class.types.DftButtonTest'
local policy_intf_types = require 'chassis.json_types.Policy'
local properties_intf_types = require 'chassis.json_types.Properties'
local led_intf_types = require 'chassis.json_types.Led'
local dimension_intf_types = require 'chassis.json_types.Dimension'
local chassis_intf_types = require 'chassis.json_types.Chassis'
local metric_intf_types = require 'chassis.json_types.Metric'
local manufacture_intf_types = require 'chassis.json_types.Manufacture'
local ncsi_capabilities_intf_types = require 'chassis.json_types.NCSICapabilities'
local super_pod_label_intf_types = require 'chassis.json_types.SuperPodLabel'
local enclosure_intf_types = require 'chassis.json_types.Enclosure'

local LedPolicy = {
    ['table_name'] = 't_LedPolicy',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['readOnly'] = true,
            ['default'] = 1,
            ['validator'] = led_policy_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = 1},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Led.Policy'] = {
            ['Normal'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Normal等级亮灯策略',
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['validator'] = policy_intf_types.Normal
            },
            ['Minor'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Minor等级亮灯策略',
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['validator'] = policy_intf_types.Minor
            },
            ['Major'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Major等级亮灯策略',
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['validator'] = policy_intf_types.Major
            },
            ['Critical'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Critical等级亮灯策略',
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['validator'] = policy_intf_types.Critical
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Leds'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Led.Policy'] = {
            ['property_defaults'] = {
                ['Normal'] = policy_intf_types.Normal.default[1],
                ['Minor'] = policy_intf_types.Minor.default[1],
                ['Major'] = policy_intf_types.Major.default[1],
                ['Critical'] = policy_intf_types.Critical.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = policy_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Led = {
    ['table_name'] = 't_Led',
    ['prop_configs'] = {
        ['CtrlValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['minimum'] = 0,
            ['maximum'] = 255,
            ['validator'] = led_class_types.CtrlValue
        },
        ['DefaultOSColor'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.DefaultOSColor},
        ['DefaultLCSColor'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = led_class_types.DefaultLCSColor
        },
        ['LCSColor'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.LCSColor},
        ['LCSState'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.LCSState},
        ['OSColor'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.OSColor},
        ['OSState'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.OSState},
        ['LampTestColor'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.LampTestColor},
        ['LampTestDuration'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = led_class_types.LampTestDuration
        }
    },
    ['default_props'] = {
        ['CtrlValue'] = led_class_types.CtrlValue.default[1],
        ['DefaultOSColor'] = led_class_types.DefaultOSColor.default[1],
        ['DefaultLCSColor'] = led_class_types.DefaultLCSColor.default[1],
        ['LCSColor'] = led_class_types.LCSColor.default[1],
        ['LCSState'] = led_class_types.LCSState.default[1],
        ['OSColor'] = led_class_types.OSColor.default[1],
        ['OSState'] = led_class_types.OSState.default[1],
        ['LampTestColor'] = led_class_types.LampTestColor.default[1],
        ['LampTestDuration'] = led_class_types.LampTestDuration.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Led'] = {
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '系统id',
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.SystemId
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'Led灯的名称',
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.Name
            },
            ['OnDuration'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '亮灯持续时间 默认值0',
                ['validator'] = led_intf_types.OnDuration
            },
            ['OffDuration'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '关灯持续时间 默认值0',
                ['validator'] = led_intf_types.OffDuration
            },
            ['Capability'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '颜色，3:绿色，2:红色',
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.Capability
            },
            ['State'] = {
                ['baseType'] = 'U8',
                ['description'] = '当前Led灯的状态',
                ['usage'] = {'ResetPer'},
                ['validator'] = led_intf_types.State
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '每个LED灯都会对应一个固定id',
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = led_intf_types.Id
            },
            ['FruId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '关联的FRU id',
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.FruId
            },
            ['ColorCapabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Led灯支持的颜色能力',
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.ColorCapabilities
            },
            ['LocalControlStateColor'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '本地控制模式下的颜色',
                ['validator'] = led_intf_types.LocalControlStateColor
            },
            ['OverrideStateColor'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '超驰状态下的颜色',
                ['validator'] = led_intf_types.OverrideStateColor
            },
            ['Mode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Led模式',
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.Mode
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Led'] = {
            ['SetState'] = {
                ['description'] = '设置Led灯的状态',
                ['req'] = {
                    {['baseType'] = 'U8', ['description'] = 'Led灯的状态', ['param'] = 'State'},
                    {['baseType'] = 'U8', ['description'] = '闪烁状态持续时长', ['param'] = 'Interval'}
                },
                ['rsp'] = {
                    {['baseType'] = 'U8', ['description'] = 'Led灯的状态', ['param'] = 'State'},
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '闪烁状态下亮灯持续时长',
                        ['param'] = 'OnDuration'
                    },
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '闪烁状态下关灯持续时长',
                        ['param'] = 'OffDuration'
                    }
                },
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Leds/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Led'] = {
            ['property_defaults'] = {
                ['SystemId'] = led_intf_types.SystemId.default[1],
                ['Name'] = led_intf_types.Name.default[1],
                ['OnDuration'] = 0,
                ['OffDuration'] = 0,
                ['Capability'] = led_intf_types.Capability.default[1],
                ['State'] = led_intf_types.State.default[1],
                ['Id'] = led_intf_types.Id.default[1],
                ['FruId'] = led_intf_types.FruId.default[1],
                ['ColorCapabilities'] = led_intf_types.ColorCapabilities.default[1],
                ['LocalControlStateColor'] = led_intf_types.LocalControlStateColor.default[1],
                ['OverrideStateColor'] = led_intf_types.OverrideStateColor.default[1],
                ['Mode'] = led_intf_types.Mode.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetState'] = privilege.BasicSetting}},
            ['interface_types'] = led_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Dimension = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.Dimension'] = {
            ['HeightU'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['description'] = '机框高度',
                ['usage'] = {'CSR'},
                ['validator'] = dimension_intf_types.HeightU
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/Dimension'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.Dimension'] = {
            ['property_defaults'] = {['HeightU'] = dimension_intf_types.HeightU.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = dimension_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Chassis = {
    ['table_name'] = 't_Chassis',
    ['prop_configs'] = {
        ['IntrusionACOn'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.IntrusionACOn
        },
        ['IntrusionACOff'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.IntrusionACOff
        },
        ['IntrusionACOnClear'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.IntrusionACOnClear
        },
        ['IntrusionACOffClear'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.IntrusionACOffClear
        },
        ['CoverStatus'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = chassis_class_types.CoverStatus},
        ['LastIntrusionACOn'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = chassis_class_types.LastIntrusionACOn
        },
        ['UidButtonAccessor'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.UidButtonAccessor
        },
        ['UidButtonScanner'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.UidButtonScanner
        },
        ['UidButtonLongAccessor'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.UidButtonLongAccessor
        },
        ['UidButtonLongScanner'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.UidButtonLongScanner
        },
        ['UidButtonTestFlag'] = {
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = chassis_class_types.UidButtonTestFlag
        },
        ['UidButtonTestResult'] = {
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = chassis_class_types.UidButtonTestResult
        },
        ['UidButtonTestStatus'] = {
            ['baseType'] = 'U8',
            ['default'] = 129,
            ['validator'] = chassis_class_types.UidButtonTestStatus
        }
    },
    ['default_props'] = {
        ['IntrusionACOn'] = chassis_class_types.IntrusionACOn.default[1],
        ['IntrusionACOff'] = chassis_class_types.IntrusionACOff.default[1],
        ['IntrusionACOnClear'] = chassis_class_types.IntrusionACOnClear.default[1],
        ['IntrusionACOffClear'] = chassis_class_types.IntrusionACOffClear.default[1],
        ['CoverStatus'] = chassis_class_types.CoverStatus.default[1],
        ['LastIntrusionACOn'] = 0,
        ['UidButtonAccessor'] = chassis_class_types.UidButtonAccessor.default[1],
        ['UidButtonScanner'] = chassis_class_types.UidButtonScanner.default[1],
        ['UidButtonLongAccessor'] = chassis_class_types.UidButtonLongAccessor.default[1],
        ['UidButtonLongScanner'] = chassis_class_types.UidButtonLongScanner.default[1],
        ['UidButtonTestFlag'] = true,
        ['UidButtonTestResult'] = 255,
        ['UidButtonTestStatus'] = 129
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '机框名',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['primaryKey'] = true,
                ['validator'] = chassis_intf_types.Name
            },
            ['IntrusionFlag'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '开箱事件标志 开箱：0x01 关闭：0x0',
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.IntrusionFlag
            },
            ['UidButtonPressed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'UID按钮按下标志',
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.UidButtonPressed
            },
            ['UidButtonLongPressed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'UID按钮长按标志',
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.UidButtonLongPressed
            },
            ['ChassisType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '当前管理软件类型',
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.ChassisType
            },
            ['Location'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['description'] = '位置信息',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'BasicSetting'}},
                ['validator'] = chassis_intf_types.Location
            },
            ['TopologyConfigId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 65535,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '产品组网拓扑',
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.TopologyConfigId
            },
            ['DeviceSpecication'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/DeviceMaxCount'},
                ['description'] = '设备最大数量集合',
                ['readOnly'] = true,
                ['validator'] = chassis_intf_types.DeviceSpecication
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['description'] = '根据MetricName获取采集项数据',
                ['req'] = {{['baseType'] = 'String[]', ['description'] = '采集项名称', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/DataCollectionItem'},
                        ['description'] = '采集项数据',
                        ['param'] = 'Val'
                    }
                }
            },
            ['GetItems'] = {
                ['description'] = '获取采集项描述信息',
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['description'] = '采集主体名称', ['param'] = 'Component'}, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['description'] = '分类信息',
                        ['param'] = 'Classification'
                    }, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['description'] = '标识信息',
                        ['param'] = 'Identification'
                    }, {['baseType'] = 'String[]', ['description'] = '采集项名称', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {
                ['description'] = '将数据采集开关同步到业务组件',
                ['req'] = {{['baseType'] = 'U8', ['description'] = '数据采集开关', ['param'] = 'Enabled'}},
                ['rsp'] = {}
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis'] = {
            ['property_defaults'] = {
                ['Name'] = chassis_intf_types.Name.default[1],
                ['IntrusionFlag'] = chassis_intf_types.IntrusionFlag.default[1],
                ['UidButtonPressed'] = chassis_intf_types.UidButtonPressed.default[1],
                ['UidButtonLongPressed'] = chassis_intf_types.UidButtonLongPressed.default[1],
                ['ChassisType'] = chassis_intf_types.ChassisType.default[1],
                ['Location'] = chassis_intf_types.Location.default[1],
                ['TopologyConfigId'] = 65535,
                ['DeviceSpecication'] = chassis_intf_types.DeviceSpecication.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['Location'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.BasicSetting}}
            },
            ['interface_types'] = chassis_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftChassisCover = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/OperateTest/DftChassisCover/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NCSICapabilities = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NCSICapabilities'] = {
            ['PCIeNCSIEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'PCIE标卡NCSI线缆在位标记',
                ['usage'] = {'CSR'},
                ['validator'] = ncsi_capabilities_intf_types.PCIeNCSIEnabled
            },
            ['PCIeNCSISupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '用于生产查询主板对PCIE标卡NCSI功能支持能力',
                ['usage'] = {'CSR'},
                ['validator'] = ncsi_capabilities_intf_types.PCIeNCSISupported
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/NCSICapabilities'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NCSICapabilities'] = {
            ['property_defaults'] = {
                ['PCIeNCSIEnabled'] = ncsi_capabilities_intf_types.PCIeNCSIEnabled.default[1],
                ['PCIeNCSISupported'] = ncsi_capabilities_intf_types.PCIeNCSISupported.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = ncsi_capabilities_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local LedDispControl = {
    ['prop_configs'] = {
        ['LedTubeSupport'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = led_disp_control_class_types.LedTubeSupport
        },
        ['LeftLedTube'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = led_disp_control_class_types.LeftLedTube
        },
        ['MidLedTube'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = led_disp_control_class_types.MidLedTube
        },
        ['RightLedTube'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = led_disp_control_class_types.RightLedTube
        }
    },
    ['default_props'] = {['LedTubeSupport'] = false, ['LeftLedTube'] = 0, ['MidLedTube'] = 0, ['RightLedTube'] = 0}
}

local I2cLed = {
    ['prop_configs'] = {
        ['CtrlValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = i2c_led_class_types.CtrlValue},
        ['LedOnValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = i2c_led_class_types.LedOnValue}
    },
    ['default_props'] = {
        ['CtrlValue'] = i2c_led_class_types.CtrlValue.default[1],
        ['LedOnValue'] = i2c_led_class_types.LedOnValue.default[1]
    }
}

local DftPysicalLed = {
    ['prop_configs'] = {
        ['DftEnable'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_pysical_led_class_types.DftEnable
        }
    },
    ['default_props'] = {['DftEnable'] = dft_pysical_led_class_types.DftEnable.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/CheckTest/DftPysicalLed/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftUidButton = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/OperateTest/DftUidButton/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftLedIntelligence = {
    ['prop_configs'] = {
        ['DftEnable'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_led_intelligence_class_types.DftEnable
        }
    },
    ['default_props'] = {['DftEnable'] = dft_led_intelligence_class_types.DftEnable.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/CheckTest/DftLedIntelligence/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftLedTube = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/CheckTest/DftLedTube/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftLedTubeIntelligence = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/CheckTest/DftLedTubeIntelligence/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local ChassisTable = {
    ['table_name'] = 't_chassis_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'ResetPer'},
            ['validator'] = chassis_table_class_types.Id
        },
        ['BmcHardResetFlag'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = chassis_table_class_types.BmcHardResetFlag
        },
        ['ProcessRestartFlag'] = {
            ['usage'] = {'TemporaryPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = chassis_table_class_types.ProcessRestartFlag
        }
    },
    ['default_props'] = {
        ['Id'] = chassis_table_class_types.Id.default[1],
        ['BmcHardResetFlag'] = 0,
        ['ProcessRestartFlag'] = 0
    }
}

local SuperPodLabel = {
    ['table_name'] = 't_SuperPodLabel',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['readOnly'] = true,
            ['default'] = 1,
            ['validator'] = super_pod_label_class_types.Id
        },
        ['SuperPodIdAcc'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['description'] = '关联硬件SuperPodId寄存器,进行写值',
            ['validator'] = super_pod_label_class_types.SuperPodIdAcc
        },
        ['ServerIndexAcc'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['description'] = '关联硬件ServerIndex寄存器,进行写值',
            ['validator'] = super_pod_label_class_types.ServerIndexAcc
        },
        ['SuperPodSizeAcc'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['description'] = '关联硬件SuperPodSize寄存器,进行写值',
            ['validator'] = super_pod_label_class_types.SuperPodSizeAcc
        },
        ['DefaultSuperPodId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['validator'] = super_pod_label_class_types.DefaultSuperPodId
        },
        ['DefaultServerIndex'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['default'] = 65535,
            ['validator'] = super_pod_label_class_types.DefaultServerIndex
        },
        ['DefaultSuperPodSize'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['default'] = 384,
            ['validator'] = super_pod_label_class_types.DefaultSuperPodSize
        },
        ['Crc16'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['description'] = '计算ServerIndex、SuperPodSize、SuperPodId crc16值',
            ['validator'] = super_pod_label_class_types.Crc16
        }
    },
    ['default_props'] = {
        ['Id'] = 1,
        ['SuperPodIdAcc'] = super_pod_label_class_types.SuperPodIdAcc.default[1],
        ['ServerIndexAcc'] = super_pod_label_class_types.ServerIndexAcc.default[1],
        ['SuperPodSizeAcc'] = super_pod_label_class_types.SuperPodSizeAcc.default[1],
        ['DefaultSuperPodId'] = 4294967295,
        ['DefaultServerIndex'] = 65535,
        ['DefaultSuperPodSize'] = 384,
        ['Crc16'] = 0
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.SuperPodLabel'] = {
            ['SuperPodId'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 4294967295,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '超节点集合Id,默认值4294967295',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = super_pod_label_intf_types.SuperPodId
            },
            ['ServerIndex'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 65535,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '超节点内的计算节点Id编号,默认值65535',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = super_pod_label_intf_types.ServerIndex
            },
            ['SuperPodSize'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 384,
                ['minimum'] = '1',
                ['maximum'] = '384',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '超节点规模(npu卡的数),默认值384',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = super_pod_label_intf_types.SuperPodSize
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.SuperPodLabel'] = {
            ['SetSuperPodId'] = {
                ['description'] = '设置超节点ID',
                ['req'] = {{['baseType'] = 'U32', ['description'] = '超节点ID', ['param'] = 'SuperPodId'}},
                ['rsp'] = {{['baseType'] = 'Boolean', ['description'] = '操作成功或失败', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetServerIndex'] = {
                ['description'] = '设置超节点服务器编号',
                ['req'] = {{['baseType'] = 'U16', ['description'] = '服务器编号', ['param'] = 'ServerIndex'}},
                ['rsp'] = {{['baseType'] = 'Boolean', ['description'] = '操作成功或失败', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetSuperPodSize'] = {
                ['description'] = '设置超节点容量',
                ['req'] = {{['baseType'] = 'U16', ['description'] = '超节点容量', ['param'] = 'SuperPodSize'}},
                ['rsp'] = {{['baseType'] = 'Boolean', ['description'] = '操作成功或失败', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['RestoreDefaults'] = {
                ['description'] = '恢复超节点属性默认值',
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'Boolean', ['description'] = '操作成功或失败', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/SuperPodLabel'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.SuperPodLabel'] = {
            ['property_defaults'] = {['SuperPodId'] = 4294967295, ['ServerIndex'] = 65535, ['SuperPodSize'] = 384},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['SetSuperPodId'] = privilege.BasicSetting,
                    ['SetServerIndex'] = privilege.BasicSetting,
                    ['SetSuperPodSize'] = privilege.BasicSetting,
                    ['RestoreDefaults'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = super_pod_label_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftButtonTest = {
    ['prop_configs'] = {
        ['PressEvent'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_button_test_class_types.PressEvent
        },
        ['ExpectedValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_button_test_class_types.ExpectedValue
        },
        ['ClearPressEvent'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_button_test_class_types.ClearPressEvent
        }
    },
    ['default_props'] = {
        ['PressEvent'] = dft_button_test_class_types.PressEvent.default[1],
        ['ExpectedValue'] = dft_button_test_class_types.ExpectedValue.default[1],
        ['ClearPressEvent'] = dft_button_test_class_types.ClearPressEvent.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/OperateTest/DftButtonTest/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Enclosure = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.Enclosure'] = {
            ['CabinetSerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '机柜sn',
                ['validator'] = enclosure_intf_types.CabinetSerialNumber
            },
            ['EnclosureSerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '机框sn',
                ['validator'] = enclosure_intf_types.EnclosureSerialNumber
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/Enclosure'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.Enclosure'] = {
            ['property_defaults'] = {
                ['CabinetSerialNumber'] = enclosure_intf_types.CabinetSerialNumber.default[1],
                ['EnclosureSerialNumber'] = enclosure_intf_types.EnclosureSerialNumber.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = enclosure_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('LedPolicy', LedPolicy):set_bus(bus)
    class('Led', Led):set_bus(bus)
    class('Dimension', Dimension):set_bus(bus)
    class('Chassis', Chassis):set_bus(bus)
    class('DftChassisCover', DftChassisCover):set_bus(bus)
    class('NCSICapabilities', NCSICapabilities):set_bus(bus)
    class('LedDispControl', LedDispControl):set_bus(bus)
    class('I2cLed', I2cLed):set_bus(bus)
    class('DftPysicalLed', DftPysicalLed):set_bus(bus)
    class('DftUidButton', DftUidButton):set_bus(bus)
    class('DftLedIntelligence', DftLedIntelligence):set_bus(bus)
    class('DftLedTube', DftLedTube):set_bus(bus)
    class('DftLedTubeIntelligence', DftLedTubeIntelligence):set_bus(bus)
    class('ChassisTable', ChassisTable):set_bus(bus)
    class('SuperPodLabel', SuperPodLabel):set_bus(bus)
    class('DftButtonTest', DftButtonTest):set_bus(bus)
    class('Enclosure', Enclosure):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplLedLedSetState(cb)
    class('Led')['bmc.kepler.Systems.Led'].SetState = function(obj, ctx, ...)
        local req = led_intf_types.SetStateReq.new(...):validate(nil, nil, true)
        local rsp = led_intf_types.SetStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplChassisMetricGetData(cb)
    class('Chassis')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplChassisMetricGetItems(cb)
    class('Chassis')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplChassisMetricSynDataAcquisitionEnable(cb)
    class('Chassis')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftChassisCoverManufactureStart(cb)
    class('DftChassisCover')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftChassisCoverManufactureStop(cb)
    class('DftChassisCover')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftChassisCoverManufactureGetResult(cb)
    class('DftChassisCover')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPysicalLedManufactureStart(cb)
    class('DftPysicalLed')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPysicalLedManufactureStop(cb)
    class('DftPysicalLed')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPysicalLedManufactureGetResult(cb)
    class('DftPysicalLed')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftUidButtonManufactureStart(cb)
    class('DftUidButton')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftUidButtonManufactureStop(cb)
    class('DftUidButton')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftUidButtonManufactureGetResult(cb)
    class('DftUidButton')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedIntelligenceManufactureStart(cb)
    class('DftLedIntelligence')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedIntelligenceManufactureStop(cb)
    class('DftLedIntelligence')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedIntelligenceManufactureGetResult(cb)
    class('DftLedIntelligence')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeManufactureStart(cb)
    class('DftLedTube')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeManufactureStop(cb)
    class('DftLedTube')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeManufactureGetResult(cb)
    class('DftLedTube')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeIntelligenceManufactureStart(cb)
    class('DftLedTubeIntelligence')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeIntelligenceManufactureStop(cb)
    class('DftLedTubeIntelligence')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeIntelligenceManufactureGetResult(cb)
    class('DftLedTubeIntelligence')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelSetSuperPodId(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].SetSuperPodId = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.SetSuperPodIdReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.SetSuperPodIdRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelSetServerIndex(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].SetServerIndex = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.SetServerIndexReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.SetServerIndexRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelSetSuperPodSize(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].SetSuperPodSize = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.SetSuperPodSizeReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.SetSuperPodSizeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelRestoreDefaults(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].RestoreDefaults = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.RestoreDefaultsReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.RestoreDefaultsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonTestManufactureStart(cb)
    class('DftButtonTest')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonTestManufactureStop(cb)
    class('DftButtonTest')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonTestManufactureGetResult(cb)
    class('DftButtonTest')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
