-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Sensors = {}

---@class Sensors.DiscreteSensorItem
---@field SensorNumber integer
---@field SensorName string
---@field SensorIdentifier string
---@field SensorStatus string
---@field SystemId integer
local TDiscreteSensorItem = {}
TDiscreteSensorItem.__index = TDiscreteSensorItem
TDiscreteSensorItem.group = {}

local function TDiscreteSensorItem_from_obj(obj)
    return setmetatable(obj, TDiscreteSensorItem)
end

function TDiscreteSensorItem.new(SensorNumber, SensorName, SensorIdentifier, SensorStatus, SystemId)
    return TDiscreteSensorItem_from_obj({
        SensorNumber = SensorNumber,
        SensorName = SensorName,
        SensorIdentifier = SensorIdentifier,
        SensorStatus = SensorStatus,
        SystemId = SystemId
    })
end
---@param obj Sensors.DiscreteSensorItem
function TDiscreteSensorItem:init_from_obj(obj)
    self.SensorNumber = obj.SensorNumber
    self.SensorName = obj.SensorName
    self.SensorIdentifier = obj.SensorIdentifier
    self.SensorStatus = obj.SensorStatus
    self.SystemId = obj.SystemId
end

function TDiscreteSensorItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiscreteSensorItem.group)
end

TDiscreteSensorItem.from_obj = TDiscreteSensorItem_from_obj

TDiscreteSensorItem.proto_property = {'SensorNumber', 'SensorName', 'SensorIdentifier', 'SensorStatus', 'SystemId'}

TDiscreteSensorItem.default = {0, '', '', '', 0}

TDiscreteSensorItem.struct = {
    {name = 'SensorNumber', is_array = false, struct = nil}, {name = 'SensorName', is_array = false, struct = nil},
    {name = 'SensorIdentifier', is_array = false, struct = nil},
    {name = 'SensorStatus', is_array = false, struct = nil}, {name = 'SystemId', is_array = false, struct = nil}
}

function TDiscreteSensorItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorIdentifier', self.SensorIdentifier, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorStatus', self.SensorStatus, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TDiscreteSensorItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiscreteSensorItem.proto_property, errs, need_convert)
    return self
end

function TDiscreteSensorItem:unpack(_)
    return self.SensorNumber, self.SensorName, self.SensorIdentifier, self.SensorStatus, self.SystemId
end

Sensors.DiscreteSensorItem = TDiscreteSensorItem

---@class Sensors.KeyValueTable
---@field Key string
---@field Value string
local TKeyValueTable = {}
TKeyValueTable.__index = TKeyValueTable
TKeyValueTable.group = {}

local function TKeyValueTable_from_obj(obj)
    return setmetatable(obj, TKeyValueTable)
end

function TKeyValueTable.new(Key, Value)
    return TKeyValueTable_from_obj({Key = Key, Value = Value})
end
---@param obj Sensors.KeyValueTable
function TKeyValueTable:init_from_obj(obj)
    self.Key = obj.Key
    self.Value = obj.Value
end

function TKeyValueTable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKeyValueTable.group)
end

TKeyValueTable.from_obj = TKeyValueTable_from_obj

TKeyValueTable.proto_property = {'Key', 'Value'}

TKeyValueTable.default = {'', ''}

TKeyValueTable.struct = {
    {name = 'Key', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TKeyValueTable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Key', self.Key, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TKeyValueTable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TKeyValueTable.proto_property, errs, need_convert)
    return self
end

function TKeyValueTable:unpack(_)
    return self.Key, self.Value
end

Sensors.KeyValueTable = TKeyValueTable

---@class Sensors.SelInfo
---@field MappingTable Sensors.KeyValueTable[]
local TSelInfo = {}
TSelInfo.__index = TSelInfo
TSelInfo.group = {}

local function TSelInfo_from_obj(obj)
    obj.MappingTable = utils.from_obj(Sensors.KeyValueTable, obj.MappingTable, true)
    return setmetatable(obj, TSelInfo)
end

function TSelInfo.new(MappingTable)
    return TSelInfo_from_obj({MappingTable = MappingTable})
end
---@param obj Sensors.SelInfo
function TSelInfo:init_from_obj(obj)
    self.MappingTable = obj.MappingTable
end

function TSelInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelInfo.group)
end

TSelInfo.from_obj = TSelInfo_from_obj

TSelInfo.proto_property = {'MappingTable'}

TSelInfo.default = {{}}

TSelInfo.struct = {{name = 'MappingTable', is_array = true, struct = Sensors.KeyValueTable.struct}}

function TSelInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.MappingTable) do
        Sensors.KeyValueTable.new(v.Key, v.Value):validate(prefix, errs, need_convert)
    end

    TSelInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelInfo.proto_property, errs, need_convert)
    return self
end

function TSelInfo:unpack(raw)
    return utils.unpack(raw, self.MappingTable, true)
end

Sensors.SelInfo = TSelInfo

---@class Sensors.ThresholdSensorItem
---@field SensorNumber integer
---@field SensorName string
---@field SensorIdentifier string
---@field SensorUnit string
---@field SensorStatus string
---@field SensorReading string
---@field LowerThresholdFatal string
---@field LowerThresholdCritical string
---@field LowerThresholdNonCritical string
---@field UpperThresholdNonCritical string
---@field UpperThresholdCritical string
---@field UpperThresholdFatal string
---@field SensorType integer
---@field Status string
---@field Health string
---@field SystemId integer
local TThresholdSensorItem = {}
TThresholdSensorItem.__index = TThresholdSensorItem
TThresholdSensorItem.group = {}

local function TThresholdSensorItem_from_obj(obj)
    return setmetatable(obj, TThresholdSensorItem)
end

function TThresholdSensorItem.new(SensorNumber, SensorName, SensorIdentifier, SensorUnit, SensorStatus, SensorReading,
    LowerThresholdFatal, LowerThresholdCritical, LowerThresholdNonCritical, UpperThresholdNonCritical,
    UpperThresholdCritical, UpperThresholdFatal, SensorType, Status, Health, SystemId)
    return TThresholdSensorItem_from_obj({
        SensorNumber = SensorNumber,
        SensorName = SensorName,
        SensorIdentifier = SensorIdentifier,
        SensorUnit = SensorUnit,
        SensorStatus = SensorStatus,
        SensorReading = SensorReading,
        LowerThresholdFatal = LowerThresholdFatal,
        LowerThresholdCritical = LowerThresholdCritical,
        LowerThresholdNonCritical = LowerThresholdNonCritical,
        UpperThresholdNonCritical = UpperThresholdNonCritical,
        UpperThresholdCritical = UpperThresholdCritical,
        UpperThresholdFatal = UpperThresholdFatal,
        SensorType = SensorType,
        Status = Status,
        Health = Health,
        SystemId = SystemId
    })
end
---@param obj Sensors.ThresholdSensorItem
function TThresholdSensorItem:init_from_obj(obj)
    self.SensorNumber = obj.SensorNumber
    self.SensorName = obj.SensorName
    self.SensorIdentifier = obj.SensorIdentifier
    self.SensorUnit = obj.SensorUnit
    self.SensorStatus = obj.SensorStatus
    self.SensorReading = obj.SensorReading
    self.LowerThresholdFatal = obj.LowerThresholdFatal
    self.LowerThresholdCritical = obj.LowerThresholdCritical
    self.LowerThresholdNonCritical = obj.LowerThresholdNonCritical
    self.UpperThresholdNonCritical = obj.UpperThresholdNonCritical
    self.UpperThresholdCritical = obj.UpperThresholdCritical
    self.UpperThresholdFatal = obj.UpperThresholdFatal
    self.SensorType = obj.SensorType
    self.Status = obj.Status
    self.Health = obj.Health
    self.SystemId = obj.SystemId
end

function TThresholdSensorItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TThresholdSensorItem.group)
end

TThresholdSensorItem.from_obj = TThresholdSensorItem_from_obj

TThresholdSensorItem.proto_property = {
    'SensorNumber', 'SensorName', 'SensorIdentifier', 'SensorUnit', 'SensorStatus', 'SensorReading',
    'LowerThresholdFatal', 'LowerThresholdCritical', 'LowerThresholdNonCritical', 'UpperThresholdNonCritical',
    'UpperThresholdCritical', 'UpperThresholdFatal', 'SensorType', 'Status', 'Health', 'SystemId'
}

TThresholdSensorItem.default = {0, '', '', '', '', '', '', '', '', '', '', '', 0, '', '', 0}

TThresholdSensorItem.struct = {
    {name = 'SensorNumber', is_array = false, struct = nil}, {name = 'SensorName', is_array = false, struct = nil},
    {name = 'SensorIdentifier', is_array = false, struct = nil}, {name = 'SensorUnit', is_array = false, struct = nil},
    {name = 'SensorStatus', is_array = false, struct = nil}, {name = 'SensorReading', is_array = false, struct = nil},
    {name = 'LowerThresholdFatal', is_array = false, struct = nil},
    {name = 'LowerThresholdCritical', is_array = false, struct = nil},
    {name = 'LowerThresholdNonCritical', is_array = false, struct = nil},
    {name = 'UpperThresholdNonCritical', is_array = false, struct = nil},
    {name = 'UpperThresholdCritical', is_array = false, struct = nil},
    {name = 'UpperThresholdFatal', is_array = false, struct = nil},
    {name = 'SensorType', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil},
    {name = 'Health', is_array = false, struct = nil}, {name = 'SystemId', is_array = false, struct = nil}
}

function TThresholdSensorItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorIdentifier', self.SensorIdentifier, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorUnit', self.SensorUnit, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorStatus', self.SensorStatus, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorReading', self.SensorReading, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'LowerThresholdFatal', self.LowerThresholdFatal, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'LowerThresholdCritical', self.LowerThresholdCritical, 'string', false, errs,
        need_convert)
    validate.Optional(prefix .. 'LowerThresholdNonCritical', self.LowerThresholdNonCritical, 'string', false, errs,
        need_convert)
    validate.Optional(prefix .. 'UpperThresholdNonCritical', self.UpperThresholdNonCritical, 'string', false, errs,
        need_convert)
    validate.Optional(prefix .. 'UpperThresholdCritical', self.UpperThresholdCritical, 'string', false, errs,
        need_convert)
    validate.Optional(prefix .. 'UpperThresholdFatal', self.UpperThresholdFatal, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Health', self.Health, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TThresholdSensorItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TThresholdSensorItem.proto_property, errs, need_convert)
    return self
end

function TThresholdSensorItem:unpack(_)
    return self.SensorNumber, self.SensorName, self.SensorIdentifier, self.SensorUnit, self.SensorStatus,
        self.SensorReading, self.LowerThresholdFatal, self.LowerThresholdCritical, self.LowerThresholdNonCritical,
        self.UpperThresholdNonCritical, self.UpperThresholdCritical, self.UpperThresholdFatal, self.SensorType,
        self.Status, self.Health, self.SystemId
end

Sensors.ThresholdSensorItem = TThresholdSensorItem

---@class Sensors.AllSensorItem
---@field SensorNumber integer
---@field SensorName string
---@field SensorUnit string
---@field SensorStatus string
---@field SensorReading string
---@field LowerFatal string
---@field LowerCritical string
---@field LowerNonCritical string
---@field UpperNonCritical string
---@field UpperCritical string
---@field UpperFatal string
---@field PosHysteresis string
---@field NegHysteresis string
---@field SensorType integer
---@field BaseUnit integer
---@field ReadingType integer
---@field SystemId integer
local TAllSensorItem = {}
TAllSensorItem.__index = TAllSensorItem
TAllSensorItem.group = {}

local function TAllSensorItem_from_obj(obj)
    return setmetatable(obj, TAllSensorItem)
end

function TAllSensorItem.new(SensorNumber, SensorName, SensorUnit, SensorStatus, SensorReading, LowerFatal,
    LowerCritical, LowerNonCritical, UpperNonCritical, UpperCritical, UpperFatal, PosHysteresis, NegHysteresis,
    SensorType, BaseUnit, ReadingType, SystemId)
    return TAllSensorItem_from_obj({
        SensorNumber = SensorNumber,
        SensorName = SensorName,
        SensorUnit = SensorUnit,
        SensorStatus = SensorStatus,
        SensorReading = SensorReading,
        LowerFatal = LowerFatal,
        LowerCritical = LowerCritical,
        LowerNonCritical = LowerNonCritical,
        UpperNonCritical = UpperNonCritical,
        UpperCritical = UpperCritical,
        UpperFatal = UpperFatal,
        PosHysteresis = PosHysteresis,
        NegHysteresis = NegHysteresis,
        SensorType = SensorType,
        BaseUnit = BaseUnit,
        ReadingType = ReadingType,
        SystemId = SystemId
    })
end
---@param obj Sensors.AllSensorItem
function TAllSensorItem:init_from_obj(obj)
    self.SensorNumber = obj.SensorNumber
    self.SensorName = obj.SensorName
    self.SensorUnit = obj.SensorUnit
    self.SensorStatus = obj.SensorStatus
    self.SensorReading = obj.SensorReading
    self.LowerFatal = obj.LowerFatal
    self.LowerCritical = obj.LowerCritical
    self.LowerNonCritical = obj.LowerNonCritical
    self.UpperNonCritical = obj.UpperNonCritical
    self.UpperCritical = obj.UpperCritical
    self.UpperFatal = obj.UpperFatal
    self.PosHysteresis = obj.PosHysteresis
    self.NegHysteresis = obj.NegHysteresis
    self.SensorType = obj.SensorType
    self.BaseUnit = obj.BaseUnit
    self.ReadingType = obj.ReadingType
    self.SystemId = obj.SystemId
end

function TAllSensorItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAllSensorItem.group)
end

TAllSensorItem.from_obj = TAllSensorItem_from_obj

TAllSensorItem.proto_property = {
    'SensorNumber', 'SensorName', 'SensorUnit', 'SensorStatus', 'SensorReading', 'LowerFatal', 'LowerCritical',
    'LowerNonCritical', 'UpperNonCritical', 'UpperCritical', 'UpperFatal', 'PosHysteresis', 'NegHysteresis',
    'SensorType', 'BaseUnit', 'ReadingType', 'SystemId'
}

TAllSensorItem.default = {0, '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0}

TAllSensorItem.struct = {
    {name = 'SensorNumber', is_array = false, struct = nil}, {name = 'SensorName', is_array = false, struct = nil},
    {name = 'SensorUnit', is_array = false, struct = nil}, {name = 'SensorStatus', is_array = false, struct = nil},
    {name = 'SensorReading', is_array = false, struct = nil}, {name = 'LowerFatal', is_array = false, struct = nil},
    {name = 'LowerCritical', is_array = false, struct = nil},
    {name = 'LowerNonCritical', is_array = false, struct = nil},
    {name = 'UpperNonCritical', is_array = false, struct = nil},
    {name = 'UpperCritical', is_array = false, struct = nil}, {name = 'UpperFatal', is_array = false, struct = nil},
    {name = 'PosHysteresis', is_array = false, struct = nil}, {name = 'NegHysteresis', is_array = false, struct = nil},
    {name = 'SensorType', is_array = false, struct = nil}, {name = 'BaseUnit', is_array = false, struct = nil},
    {name = 'ReadingType', is_array = false, struct = nil}, {name = 'SystemId', is_array = false, struct = nil}
}

function TAllSensorItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorUnit', self.SensorUnit, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorStatus', self.SensorStatus, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorReading', self.SensorReading, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'LowerFatal', self.LowerFatal, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'LowerCritical', self.LowerCritical, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'LowerNonCritical', self.LowerNonCritical, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'UpperNonCritical', self.UpperNonCritical, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'UpperCritical', self.UpperCritical, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'UpperFatal', self.UpperFatal, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'PosHysteresis', self.PosHysteresis, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'NegHysteresis', self.NegHysteresis, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BaseUnit', self.BaseUnit, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingType', self.ReadingType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TAllSensorItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAllSensorItem.proto_property, errs, need_convert)
    return self
end

function TAllSensorItem:unpack(_)
    return self.SensorNumber, self.SensorName, self.SensorUnit, self.SensorStatus, self.SensorReading, self.LowerFatal,
        self.LowerCritical, self.LowerNonCritical, self.UpperNonCritical, self.UpperCritical, self.UpperFatal,
        self.PosHysteresis, self.NegHysteresis, self.SensorType, self.BaseUnit, self.ReadingType, self.SystemId
end

Sensors.AllSensorItem = TAllSensorItem

---@class Sensors.Health
---@field Health string
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health or [=[Normal]=]})
end
---@param obj Sensors.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health or [=[Normal]=]
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {''}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'string', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

Sensors.Health = THealth

---@class Sensors.ClearSelRsp
local TClearSelRsp = {}
TClearSelRsp.__index = TClearSelRsp
TClearSelRsp.group = {}

local function TClearSelRsp_from_obj(obj)
    return setmetatable(obj, TClearSelRsp)
end

function TClearSelRsp.new()
    return TClearSelRsp_from_obj({})
end
---@param obj Sensors.ClearSelRsp
function TClearSelRsp:init_from_obj(obj)

end

function TClearSelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearSelRsp.group)
end

TClearSelRsp.from_obj = TClearSelRsp_from_obj

TClearSelRsp.proto_property = {}

TClearSelRsp.default = {}

TClearSelRsp.struct = {}

function TClearSelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearSelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearSelRsp.proto_property, errs, need_convert)
    return self
end

function TClearSelRsp:unpack(_)
end

Sensors.ClearSelRsp = TClearSelRsp

---@class Sensors.ClearSelReq
local TClearSelReq = {}
TClearSelReq.__index = TClearSelReq
TClearSelReq.group = {}

local function TClearSelReq_from_obj(obj)
    return setmetatable(obj, TClearSelReq)
end

function TClearSelReq.new()
    return TClearSelReq_from_obj({})
end
---@param obj Sensors.ClearSelReq
function TClearSelReq:init_from_obj(obj)

end

function TClearSelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearSelReq.group)
end

TClearSelReq.from_obj = TClearSelReq_from_obj

TClearSelReq.proto_property = {}

TClearSelReq.default = {}

TClearSelReq.struct = {}

function TClearSelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearSelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearSelReq.proto_property, errs, need_convert)
    return self
end

function TClearSelReq:unpack(_)
end

Sensors.ClearSelReq = TClearSelReq

---@class Sensors.AddOemSelRsp
---@field RecordId integer
local TAddOemSelRsp = {}
TAddOemSelRsp.__index = TAddOemSelRsp
TAddOemSelRsp.group = {}

local function TAddOemSelRsp_from_obj(obj)
    return setmetatable(obj, TAddOemSelRsp)
end

function TAddOemSelRsp.new(RecordId)
    return TAddOemSelRsp_from_obj({RecordId = RecordId})
end
---@param obj Sensors.AddOemSelRsp
function TAddOemSelRsp:init_from_obj(obj)
    self.RecordId = obj.RecordId
end

function TAddOemSelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddOemSelRsp.group)
end

TAddOemSelRsp.from_obj = TAddOemSelRsp_from_obj

TAddOemSelRsp.proto_property = {'RecordId'}

TAddOemSelRsp.default = {0}

TAddOemSelRsp.struct = {{name = 'RecordId', is_array = false, struct = nil}}

function TAddOemSelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecordId', self.RecordId, 'uint32', false, errs, need_convert)

    TAddOemSelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddOemSelRsp.proto_property, errs, need_convert)
    return self
end

function TAddOemSelRsp:unpack(_)
    return self.RecordId
end

Sensors.AddOemSelRsp = TAddOemSelRsp

---@class Sensors.AddOemSelReq
---@field RecordType integer
---@field Timestamp integer
---@field ManufactureID integer
---@field SELDatas string
local TAddOemSelReq = {}
TAddOemSelReq.__index = TAddOemSelReq
TAddOemSelReq.group = {}

local function TAddOemSelReq_from_obj(obj)
    return setmetatable(obj, TAddOemSelReq)
end

function TAddOemSelReq.new(RecordType, Timestamp, ManufactureID, SELDatas)
    return TAddOemSelReq_from_obj({
        RecordType = RecordType,
        Timestamp = Timestamp,
        ManufactureID = ManufactureID,
        SELDatas = SELDatas
    })
end
---@param obj Sensors.AddOemSelReq
function TAddOemSelReq:init_from_obj(obj)
    self.RecordType = obj.RecordType
    self.Timestamp = obj.Timestamp
    self.ManufactureID = obj.ManufactureID
    self.SELDatas = obj.SELDatas
end

function TAddOemSelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddOemSelReq.group)
end

TAddOemSelReq.from_obj = TAddOemSelReq_from_obj

TAddOemSelReq.proto_property = {'RecordType', 'Timestamp', 'ManufactureID', 'SELDatas'}

TAddOemSelReq.default = {0, 0, 0, ''}

TAddOemSelReq.struct = {
    {name = 'RecordType', is_array = false, struct = nil}, {name = 'Timestamp', is_array = false, struct = nil},
    {name = 'ManufactureID', is_array = false, struct = nil}, {name = 'SELDatas', is_array = false, struct = nil}
}

function TAddOemSelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecordType', self.RecordType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Timestamp', self.Timestamp, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureID', self.ManufactureID, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SELDatas', self.SELDatas, 'string', false, errs, need_convert)

    TAddOemSelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddOemSelReq.proto_property, errs, need_convert)
    return self
end

function TAddOemSelReq:unpack(_)
    return self.RecordType, self.Timestamp, self.ManufactureID, self.SELDatas
end

Sensors.AddOemSelReq = TAddOemSelReq

---@class Sensors.DumpSDRRsp
local TDumpSDRRsp = {}
TDumpSDRRsp.__index = TDumpSDRRsp
TDumpSDRRsp.group = {}

local function TDumpSDRRsp_from_obj(obj)
    return setmetatable(obj, TDumpSDRRsp)
end

function TDumpSDRRsp.new()
    return TDumpSDRRsp_from_obj({})
end
---@param obj Sensors.DumpSDRRsp
function TDumpSDRRsp:init_from_obj(obj)

end

function TDumpSDRRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpSDRRsp.group)
end

TDumpSDRRsp.from_obj = TDumpSDRRsp_from_obj

TDumpSDRRsp.proto_property = {}

TDumpSDRRsp.default = {}

TDumpSDRRsp.struct = {}

function TDumpSDRRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDumpSDRRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpSDRRsp.proto_property, errs, need_convert)
    return self
end

function TDumpSDRRsp:unpack(_)
end

Sensors.DumpSDRRsp = TDumpSDRRsp

---@class Sensors.DumpSDRReq
---@field DumpMode string
local TDumpSDRReq = {}
TDumpSDRReq.__index = TDumpSDRReq
TDumpSDRReq.group = {}

local function TDumpSDRReq_from_obj(obj)
    return setmetatable(obj, TDumpSDRReq)
end

function TDumpSDRReq.new(DumpMode)
    return TDumpSDRReq_from_obj({DumpMode = DumpMode})
end
---@param obj Sensors.DumpSDRReq
function TDumpSDRReq:init_from_obj(obj)
    self.DumpMode = obj.DumpMode
end

function TDumpSDRReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpSDRReq.group)
end

TDumpSDRReq.from_obj = TDumpSDRReq_from_obj

TDumpSDRReq.proto_property = {'DumpMode'}

TDumpSDRReq.default = {''}

TDumpSDRReq.struct = {{name = 'DumpMode', is_array = false, struct = nil}}

function TDumpSDRReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DumpMode', self.DumpMode, 'string', false, errs, need_convert)

    if self.DumpMode ~= nil then
        validate.Enum(prefix .. 'DumpMode', self.DumpMode, '', {'LAN', 'BT'}, errs, need_convert)
    end

    TDumpSDRReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpSDRReq.proto_property, errs, need_convert)
    return self
end

function TDumpSDRReq:unpack(_)
    return self.DumpMode
end

Sensors.DumpSDRReq = TDumpSDRReq

---@class Sensors.GetReportedSelRsp
---@field Total integer
---@field SelList Sensors.SelInfo[]
local TGetReportedSelRsp = {}
TGetReportedSelRsp.__index = TGetReportedSelRsp
TGetReportedSelRsp.group = {}

local function TGetReportedSelRsp_from_obj(obj)
    obj.SelList = utils.from_obj(Sensors.SelInfo, obj.SelList, true)
    return setmetatable(obj, TGetReportedSelRsp)
end

function TGetReportedSelRsp.new(Total, SelList)
    return TGetReportedSelRsp_from_obj({Total = Total, SelList = SelList})
end
---@param obj Sensors.GetReportedSelRsp
function TGetReportedSelRsp:init_from_obj(obj)
    self.Total = obj.Total
    self.SelList = obj.SelList
end

function TGetReportedSelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReportedSelRsp.group)
end

TGetReportedSelRsp.from_obj = TGetReportedSelRsp_from_obj

TGetReportedSelRsp.proto_property = {'Total', 'SelList'}

TGetReportedSelRsp.default = {0, {}}

TGetReportedSelRsp.struct = {
    {name = 'Total', is_array = false, struct = nil},
    {name = 'SelList', is_array = true, struct = Sensors.SelInfo.struct}
}

function TGetReportedSelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SelList) do
        Sensors.SelInfo.new(v.MappingTable):validate(prefix, errs, need_convert)
    end

    validate.Optional(prefix .. 'Total', self.Total, 'uint16', false, errs, need_convert)

    TGetReportedSelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReportedSelRsp.proto_property, errs, need_convert)
    return self
end

function TGetReportedSelRsp:unpack(raw)
    return self.Total, utils.unpack(raw, self.SelList, true)
end

Sensors.GetReportedSelRsp = TGetReportedSelRsp

---@class Sensors.GetReportedSelReq
---@field StartId integer
---@field Count integer
local TGetReportedSelReq = {}
TGetReportedSelReq.__index = TGetReportedSelReq
TGetReportedSelReq.group = {}

local function TGetReportedSelReq_from_obj(obj)
    return setmetatable(obj, TGetReportedSelReq)
end

function TGetReportedSelReq.new(StartId, Count)
    return TGetReportedSelReq_from_obj({StartId = StartId, Count = Count})
end
---@param obj Sensors.GetReportedSelReq
function TGetReportedSelReq:init_from_obj(obj)
    self.StartId = obj.StartId
    self.Count = obj.Count
end

function TGetReportedSelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReportedSelReq.group)
end

TGetReportedSelReq.from_obj = TGetReportedSelReq_from_obj

TGetReportedSelReq.proto_property = {'StartId', 'Count'}

TGetReportedSelReq.default = {0, 0}

TGetReportedSelReq.struct = {
    {name = 'StartId', is_array = false, struct = nil}, {name = 'Count', is_array = false, struct = nil}
}

function TGetReportedSelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartId', self.StartId, 'uint64', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint16', false, errs, need_convert)

    TGetReportedSelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReportedSelReq.proto_property, errs, need_convert)
    return self
end

function TGetReportedSelReq:unpack(_)
    return self.StartId, self.Count
end

Sensors.GetReportedSelReq = TGetReportedSelReq

---@class Sensors.GetDiscreteSensorListRsp
---@field SensorList Sensors.DiscreteSensorItem[]
local TGetDiscreteSensorListRsp = {}
TGetDiscreteSensorListRsp.__index = TGetDiscreteSensorListRsp
TGetDiscreteSensorListRsp.group = {}

local function TGetDiscreteSensorListRsp_from_obj(obj)
    obj.SensorList = utils.from_obj(Sensors.DiscreteSensorItem, obj.SensorList, true)
    return setmetatable(obj, TGetDiscreteSensorListRsp)
end

function TGetDiscreteSensorListRsp.new(SensorList)
    return TGetDiscreteSensorListRsp_from_obj({SensorList = SensorList})
end
---@param obj Sensors.GetDiscreteSensorListRsp
function TGetDiscreteSensorListRsp:init_from_obj(obj)
    self.SensorList = obj.SensorList
end

function TGetDiscreteSensorListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDiscreteSensorListRsp.group)
end

TGetDiscreteSensorListRsp.from_obj = TGetDiscreteSensorListRsp_from_obj

TGetDiscreteSensorListRsp.proto_property = {'SensorList'}

TGetDiscreteSensorListRsp.default = {{}}

TGetDiscreteSensorListRsp.struct = {{name = 'SensorList', is_array = true, struct = Sensors.DiscreteSensorItem.struct}}

function TGetDiscreteSensorListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SensorList) do
        Sensors.DiscreteSensorItem.new(v.SensorNumber, v.SensorName, v.SensorIdentifier, v.SensorStatus,
            v.SystemId):validate(prefix, errs, need_convert)
    end

    TGetDiscreteSensorListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDiscreteSensorListRsp.proto_property, errs, need_convert)
    return self
end

function TGetDiscreteSensorListRsp:unpack(raw)
    return utils.unpack(raw, self.SensorList, true)
end

Sensors.GetDiscreteSensorListRsp = TGetDiscreteSensorListRsp

---@class Sensors.GetDiscreteSensorListReq
local TGetDiscreteSensorListReq = {}
TGetDiscreteSensorListReq.__index = TGetDiscreteSensorListReq
TGetDiscreteSensorListReq.group = {}

local function TGetDiscreteSensorListReq_from_obj(obj)
    return setmetatable(obj, TGetDiscreteSensorListReq)
end

function TGetDiscreteSensorListReq.new()
    return TGetDiscreteSensorListReq_from_obj({})
end
---@param obj Sensors.GetDiscreteSensorListReq
function TGetDiscreteSensorListReq:init_from_obj(obj)

end

function TGetDiscreteSensorListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDiscreteSensorListReq.group)
end

TGetDiscreteSensorListReq.from_obj = TGetDiscreteSensorListReq_from_obj

TGetDiscreteSensorListReq.proto_property = {}

TGetDiscreteSensorListReq.default = {}

TGetDiscreteSensorListReq.struct = {}

function TGetDiscreteSensorListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetDiscreteSensorListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDiscreteSensorListReq.proto_property, errs, need_convert)
    return self
end

function TGetDiscreteSensorListReq:unpack(_)
end

Sensors.GetDiscreteSensorListReq = TGetDiscreteSensorListReq

---@class Sensors.GetSelRsp
---@field Total integer
---@field SelList Sensors.SelInfo[]
local TGetSelRsp = {}
TGetSelRsp.__index = TGetSelRsp
TGetSelRsp.group = {}

local function TGetSelRsp_from_obj(obj)
    obj.SelList = utils.from_obj(Sensors.SelInfo, obj.SelList, true)
    return setmetatable(obj, TGetSelRsp)
end

function TGetSelRsp.new(Total, SelList)
    return TGetSelRsp_from_obj({Total = Total, SelList = SelList})
end
---@param obj Sensors.GetSelRsp
function TGetSelRsp:init_from_obj(obj)
    self.Total = obj.Total
    self.SelList = obj.SelList
end

function TGetSelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelRsp.group)
end

TGetSelRsp.from_obj = TGetSelRsp_from_obj

TGetSelRsp.proto_property = {'Total', 'SelList'}

TGetSelRsp.default = {0, {}}

TGetSelRsp.struct = {
    {name = 'Total', is_array = false, struct = nil},
    {name = 'SelList', is_array = true, struct = Sensors.SelInfo.struct}
}

function TGetSelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SelList) do
        Sensors.SelInfo.new(v.MappingTable):validate(prefix, errs, need_convert)
    end

    validate.Optional(prefix .. 'Total', self.Total, 'uint16', false, errs, need_convert)

    TGetSelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelRsp.proto_property, errs, need_convert)
    return self
end

function TGetSelRsp:unpack(raw)
    return self.Total, utils.unpack(raw, self.SelList, true)
end

Sensors.GetSelRsp = TGetSelRsp

---@class Sensors.GetSelReq
---@field StartId integer
---@field Count integer
local TGetSelReq = {}
TGetSelReq.__index = TGetSelReq
TGetSelReq.group = {}

local function TGetSelReq_from_obj(obj)
    return setmetatable(obj, TGetSelReq)
end

function TGetSelReq.new(StartId, Count)
    return TGetSelReq_from_obj({StartId = StartId, Count = Count})
end
---@param obj Sensors.GetSelReq
function TGetSelReq:init_from_obj(obj)
    self.StartId = obj.StartId
    self.Count = obj.Count
end

function TGetSelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelReq.group)
end

TGetSelReq.from_obj = TGetSelReq_from_obj

TGetSelReq.proto_property = {'StartId', 'Count'}

TGetSelReq.default = {0, 0}

TGetSelReq.struct = {
    {name = 'StartId', is_array = false, struct = nil}, {name = 'Count', is_array = false, struct = nil}
}

function TGetSelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartId', self.StartId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint16', false, errs, need_convert)

    TGetSelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelReq.proto_property, errs, need_convert)
    return self
end

function TGetSelReq:unpack(_)
    return self.StartId, self.Count
end

Sensors.GetSelReq = TGetSelReq

---@class Sensors.ExportSelRsp
---@field TaskId integer
local TExportSelRsp = {}
TExportSelRsp.__index = TExportSelRsp
TExportSelRsp.group = {}

local function TExportSelRsp_from_obj(obj)
    return setmetatable(obj, TExportSelRsp)
end

function TExportSelRsp.new(TaskId)
    return TExportSelRsp_from_obj({TaskId = TaskId})
end
---@param obj Sensors.ExportSelRsp
function TExportSelRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TExportSelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportSelRsp.group)
end

TExportSelRsp.from_obj = TExportSelRsp_from_obj

TExportSelRsp.proto_property = {'TaskId'}

TExportSelRsp.default = {0}

TExportSelRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TExportSelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TExportSelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportSelRsp.proto_property, errs, need_convert)
    return self
end

function TExportSelRsp:unpack(_)
    return self.TaskId
end

Sensors.ExportSelRsp = TExportSelRsp

---@class Sensors.ExportSelReq
---@field Path string
local TExportSelReq = {}
TExportSelReq.__index = TExportSelReq
TExportSelReq.group = {}

local function TExportSelReq_from_obj(obj)
    return setmetatable(obj, TExportSelReq)
end

function TExportSelReq.new(Path)
    return TExportSelReq_from_obj({Path = Path})
end
---@param obj Sensors.ExportSelReq
function TExportSelReq:init_from_obj(obj)
    self.Path = obj.Path
end

function TExportSelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportSelReq.group)
end

TExportSelReq.from_obj = TExportSelReq_from_obj

TExportSelReq.proto_property = {'Path'}

TExportSelReq.default = {''}

TExportSelReq.struct = {{name = 'Path', is_array = false, struct = nil}}

function TExportSelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Path', self.Path, 'string', false, errs, need_convert)

    TExportSelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportSelReq.proto_property, errs, need_convert)
    return self
end

function TExportSelReq:unpack(_)
    return self.Path
end

Sensors.ExportSelReq = TExportSelReq

---@class Sensors.SetSensorStatusRsp
local TSetSensorStatusRsp = {}
TSetSensorStatusRsp.__index = TSetSensorStatusRsp
TSetSensorStatusRsp.group = {}

local function TSetSensorStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetSensorStatusRsp)
end

function TSetSensorStatusRsp.new()
    return TSetSensorStatusRsp_from_obj({})
end
---@param obj Sensors.SetSensorStatusRsp
function TSetSensorStatusRsp:init_from_obj(obj)

end

function TSetSensorStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorStatusRsp.group)
end

TSetSensorStatusRsp.from_obj = TSetSensorStatusRsp_from_obj

TSetSensorStatusRsp.proto_property = {}

TSetSensorStatusRsp.default = {}

TSetSensorStatusRsp.struct = {}

function TSetSensorStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSensorStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetSensorStatusRsp:unpack(_)
end

Sensors.SetSensorStatusRsp = TSetSensorStatusRsp

---@class Sensors.SetSensorStatusReq
---@field SensorName string
---@field Status string
local TSetSensorStatusReq = {}
TSetSensorStatusReq.__index = TSetSensorStatusReq
TSetSensorStatusReq.group = {}

local function TSetSensorStatusReq_from_obj(obj)
    return setmetatable(obj, TSetSensorStatusReq)
end

function TSetSensorStatusReq.new(SensorName, Status)
    return TSetSensorStatusReq_from_obj({SensorName = SensorName, Status = Status})
end
---@param obj Sensors.SetSensorStatusReq
function TSetSensorStatusReq:init_from_obj(obj)
    self.SensorName = obj.SensorName
    self.Status = obj.Status
end

function TSetSensorStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorStatusReq.group)
end

TSetSensorStatusReq.from_obj = TSetSensorStatusReq_from_obj

TSetSensorStatusReq.proto_property = {'SensorName', 'Status'}

TSetSensorStatusReq.default = {'', ''}

TSetSensorStatusReq.struct = {
    {name = 'SensorName', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil}
}

function TSetSensorStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'string', false, errs, need_convert)

    TSetSensorStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetSensorStatusReq:unpack(_)
    return self.SensorName, self.Status
end

Sensors.SetSensorStatusReq = TSetSensorStatusReq

---@class Sensors.GetSensorListRsp
---@field SensorList Sensors.AllSensorItem[]
local TGetSensorListRsp = {}
TGetSensorListRsp.__index = TGetSensorListRsp
TGetSensorListRsp.group = {}

local function TGetSensorListRsp_from_obj(obj)
    obj.SensorList = utils.from_obj(Sensors.AllSensorItem, obj.SensorList, true)
    return setmetatable(obj, TGetSensorListRsp)
end

function TGetSensorListRsp.new(SensorList)
    return TGetSensorListRsp_from_obj({SensorList = SensorList})
end
---@param obj Sensors.GetSensorListRsp
function TGetSensorListRsp:init_from_obj(obj)
    self.SensorList = obj.SensorList
end

function TGetSensorListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorListRsp.group)
end

TGetSensorListRsp.from_obj = TGetSensorListRsp_from_obj

TGetSensorListRsp.proto_property = {'SensorList'}

TGetSensorListRsp.default = {{}}

TGetSensorListRsp.struct = {{name = 'SensorList', is_array = true, struct = Sensors.AllSensorItem.struct}}

function TGetSensorListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SensorList) do
        Sensors.AllSensorItem.new(v.SensorNumber, v.SensorName, v.SensorUnit, v.SensorStatus, v.SensorReading,
            v.LowerFatal, v.LowerCritical, v.LowerNonCritical, v.UpperNonCritical, v.UpperCritical, v.UpperFatal,
            v.PosHysteresis, v.NegHysteresis, v.SensorType, v.BaseUnit, v.ReadingType, v.SystemId):validate(prefix,
            errs, need_convert)
    end

    TGetSensorListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorListRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorListRsp:unpack(raw)
    return utils.unpack(raw, self.SensorList, true)
end

Sensors.GetSensorListRsp = TGetSensorListRsp

---@class Sensors.GetSensorListReq
local TGetSensorListReq = {}
TGetSensorListReq.__index = TGetSensorListReq
TGetSensorListReq.group = {}

local function TGetSensorListReq_from_obj(obj)
    return setmetatable(obj, TGetSensorListReq)
end

function TGetSensorListReq.new()
    return TGetSensorListReq_from_obj({})
end
---@param obj Sensors.GetSensorListReq
function TGetSensorListReq:init_from_obj(obj)

end

function TGetSensorListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorListReq.group)
end

TGetSensorListReq.from_obj = TGetSensorListReq_from_obj

TGetSensorListReq.proto_property = {}

TGetSensorListReq.default = {}

TGetSensorListReq.struct = {}

function TGetSensorListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSensorListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorListReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorListReq:unpack(_)
end

Sensors.GetSensorListReq = TGetSensorListReq

---@class Sensors.MockSensorRsp
local TMockSensorRsp = {}
TMockSensorRsp.__index = TMockSensorRsp
TMockSensorRsp.group = {}

local function TMockSensorRsp_from_obj(obj)
    return setmetatable(obj, TMockSensorRsp)
end

function TMockSensorRsp.new()
    return TMockSensorRsp_from_obj({})
end
---@param obj Sensors.MockSensorRsp
function TMockSensorRsp:init_from_obj(obj)

end

function TMockSensorRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockSensorRsp.group)
end

TMockSensorRsp.from_obj = TMockSensorRsp_from_obj

TMockSensorRsp.proto_property = {}

TMockSensorRsp.default = {}

TMockSensorRsp.struct = {}

function TMockSensorRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TMockSensorRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockSensorRsp.proto_property, errs, need_convert)
    return self
end

function TMockSensorRsp:unpack(_)
end

Sensors.MockSensorRsp = TMockSensorRsp

---@class Sensors.MockSensorReq
---@field Enabled integer
---@field SensorName string
---@field Value string
local TMockSensorReq = {}
TMockSensorReq.__index = TMockSensorReq
TMockSensorReq.group = {}

local function TMockSensorReq_from_obj(obj)
    return setmetatable(obj, TMockSensorReq)
end

function TMockSensorReq.new(Enabled, SensorName, Value)
    return TMockSensorReq_from_obj({Enabled = Enabled, SensorName = SensorName, Value = Value})
end
---@param obj Sensors.MockSensorReq
function TMockSensorReq:init_from_obj(obj)
    self.Enabled = obj.Enabled
    self.SensorName = obj.SensorName
    self.Value = obj.Value
end

function TMockSensorReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockSensorReq.group)
end

TMockSensorReq.from_obj = TMockSensorReq_from_obj

TMockSensorReq.proto_property = {'Enabled', 'SensorName', 'Value'}

TMockSensorReq.default = {0, '', ''}

TMockSensorReq.struct = {
    {name = 'Enabled', is_array = false, struct = nil}, {name = 'SensorName', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TMockSensorReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    if self.Enabled ~= nil then
        validate.ranges(prefix .. 'Enabled', self.Enabled, 0, 1, errs, need_convert)
    end

    TMockSensorReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockSensorReq.proto_property, errs, need_convert)
    return self
end

function TMockSensorReq:unpack(_)
    return self.Enabled, self.SensorName, self.Value
end

Sensors.MockSensorReq = TMockSensorReq

---@class Sensors.GetThresholdSensorListRsp
---@field SensorList Sensors.ThresholdSensorItem[]
local TGetThresholdSensorListRsp = {}
TGetThresholdSensorListRsp.__index = TGetThresholdSensorListRsp
TGetThresholdSensorListRsp.group = {}

local function TGetThresholdSensorListRsp_from_obj(obj)
    obj.SensorList = utils.from_obj(Sensors.ThresholdSensorItem, obj.SensorList, true)
    return setmetatable(obj, TGetThresholdSensorListRsp)
end

function TGetThresholdSensorListRsp.new(SensorList)
    return TGetThresholdSensorListRsp_from_obj({SensorList = SensorList})
end
---@param obj Sensors.GetThresholdSensorListRsp
function TGetThresholdSensorListRsp:init_from_obj(obj)
    self.SensorList = obj.SensorList
end

function TGetThresholdSensorListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorListRsp.group)
end

TGetThresholdSensorListRsp.from_obj = TGetThresholdSensorListRsp_from_obj

TGetThresholdSensorListRsp.proto_property = {'SensorList'}

TGetThresholdSensorListRsp.default = {{}}

TGetThresholdSensorListRsp.struct = {
    {name = 'SensorList', is_array = true, struct = Sensors.ThresholdSensorItem.struct}
}

function TGetThresholdSensorListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SensorList) do
        Sensors.ThresholdSensorItem.new(v.SensorNumber, v.SensorName, v.SensorIdentifier, v.SensorUnit, v.SensorStatus,
            v.SensorReading, v.LowerThresholdFatal, v.LowerThresholdCritical, v.LowerThresholdNonCritical,
            v.UpperThresholdNonCritical, v.UpperThresholdCritical, v.UpperThresholdFatal, v.SensorType, v.Status,
            v.Health, v.SystemId):validate(prefix, errs, need_convert)
    end

    TGetThresholdSensorListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorListRsp.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorListRsp:unpack(raw)
    return utils.unpack(raw, self.SensorList, true)
end

Sensors.GetThresholdSensorListRsp = TGetThresholdSensorListRsp

---@class Sensors.GetThresholdSensorListReq
local TGetThresholdSensorListReq = {}
TGetThresholdSensorListReq.__index = TGetThresholdSensorListReq
TGetThresholdSensorListReq.group = {}

local function TGetThresholdSensorListReq_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorListReq)
end

function TGetThresholdSensorListReq.new()
    return TGetThresholdSensorListReq_from_obj({})
end
---@param obj Sensors.GetThresholdSensorListReq
function TGetThresholdSensorListReq:init_from_obj(obj)

end

function TGetThresholdSensorListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorListReq.group)
end

TGetThresholdSensorListReq.from_obj = TGetThresholdSensorListReq_from_obj

TGetThresholdSensorListReq.proto_property = {}

TGetThresholdSensorListReq.default = {}

TGetThresholdSensorListReq.struct = {}

function TGetThresholdSensorListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetThresholdSensorListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorListReq.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorListReq:unpack(_)
end

Sensors.GetThresholdSensorListReq = TGetThresholdSensorListReq

Sensors.interface = mdb.register_interface('bmc.kepler.Chassis.Sensors', {Health = {'s', nil, true, 'Normal', false}},
    {
        GetThresholdSensorList = {
            'a{ss}', 'a(qsssssssssssyssy)', TGetThresholdSensorListReq, TGetThresholdSensorListRsp
        },
        MockSensor = {'a{ss}yss', '', TMockSensorReq, TMockSensorRsp},
        GetSensorList = {'a{ss}', 'a(qssssssssssssyyyy)', TGetSensorListReq, TGetSensorListRsp},
        SetSensorStatus = {'a{ss}ss', '', TSetSensorStatusReq, TSetSensorStatusRsp},
        ExportSel = {'a{ss}s', 'u', TExportSelReq, TExportSelRsp},
        GetSel = {'a{ss}qq', 'qa(a(ss))', TGetSelReq, TGetSelRsp},
        GetDiscreteSensorList = {'a{ss}', 'a(qsssy)', TGetDiscreteSensorListReq, TGetDiscreteSensorListRsp},
        GetReportedSel = {'a{ss}tq', 'qa(a(ss))', TGetReportedSelReq, TGetReportedSelRsp},
        DumpSDR = {'a{ss}s', '', TDumpSDRReq, TDumpSDRRsp},
        AddOemSel = {'a{ss}yuus', 'u', TAddOemSelReq, TAddOemSelRsp},
        ClearSel = {'a{ss}', '', TClearSelReq, TClearSelRsp}
    }, {})

return Sensors
