--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPowerCmd = {}

---@class ChassisIpmiCmds.GetPowerCmdReq
local TGetPowerCmdReq = {}
TGetPowerCmdReq.__index = TGetPowerCmdReq
TGetPowerCmdReq.group = {}

local function TGetPowerCmdReq_from_obj(obj)
    return setmetatable(obj, TGetPowerCmdReq)
end

function TGetPowerCmdReq.new()
    return TGetPowerCmdReq_from_obj({})
end
---@param obj ChassisIpmiCmds.GetPowerCmdReq
function TGetPowerCmdReq:init_from_obj(obj)

end

function TGetPowerCmdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPowerCmdReq.group)
end

TGetPowerCmdReq.from_obj = TGetPowerCmdReq_from_obj

TGetPowerCmdReq.proto_property = {}

TGetPowerCmdReq.default = {}

TGetPowerCmdReq.struct = {}

function TGetPowerCmdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetPowerCmdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPowerCmdReq.proto_property, errs, need_convert)
    return self
end

function TGetPowerCmdReq:unpack(_)
end

GetPowerCmd.GetPowerCmdReq = TGetPowerCmdReq

---@class ChassisIpmiCmds.GetPowerCmdRsp
---@field CompletionCode integer
---@field CurrentPowerState integer
---@field LastPowerEvent integer
---@field MiscChassisState integer
---@field FrontPanelButton integer
local TGetPowerCmdRsp = {}
TGetPowerCmdRsp.__index = TGetPowerCmdRsp
TGetPowerCmdRsp.group = {}

local function TGetPowerCmdRsp_from_obj(obj)
    return setmetatable(obj, TGetPowerCmdRsp)
end

function TGetPowerCmdRsp.new(CompletionCode, CurrentPowerState, LastPowerEvent, MiscChassisState, FrontPanelButton)
    return TGetPowerCmdRsp_from_obj({
        CompletionCode = CompletionCode,
        CurrentPowerState = CurrentPowerState,
        LastPowerEvent = LastPowerEvent,
        MiscChassisState = MiscChassisState,
        FrontPanelButton = FrontPanelButton
    })
end
---@param obj ChassisIpmiCmds.GetPowerCmdRsp
function TGetPowerCmdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.CurrentPowerState = obj.CurrentPowerState
    self.LastPowerEvent = obj.LastPowerEvent
    self.MiscChassisState = obj.MiscChassisState
    self.FrontPanelButton = obj.FrontPanelButton
end

function TGetPowerCmdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPowerCmdRsp.group)
end

TGetPowerCmdRsp.from_obj = TGetPowerCmdRsp_from_obj

TGetPowerCmdRsp.proto_property = {
    'CompletionCode', 'CurrentPowerState', 'LastPowerEvent', 'MiscChassisState', 'FrontPanelButton'
}

TGetPowerCmdRsp.default = {0, 0, 0, 0, 0}

TGetPowerCmdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'CurrentPowerState', is_array = false, struct = nil},
    {name = 'LastPowerEvent', is_array = false, struct = nil},
    {name = 'MiscChassisState', is_array = false, struct = nil},
    {name = 'FrontPanelButton', is_array = false, struct = nil}
}

function TGetPowerCmdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CurrentPowerState', self.CurrentPowerState, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LastPowerEvent', self.LastPowerEvent, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MiscChassisState', self.MiscChassisState, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FrontPanelButton', self.FrontPanelButton, 'uint8', false, errs, need_convert)

    TGetPowerCmdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPowerCmdRsp.proto_property, errs, need_convert)
    return self
end

function TGetPowerCmdRsp:unpack(_)
    return self.CompletionCode, self.CurrentPowerState, self.LastPowerEvent, self.MiscChassisState,
        self.FrontPanelButton
end

GetPowerCmd.GetPowerCmdRsp = TGetPowerCmdRsp

return GetPowerCmd
