--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceCapabilities = {}

---@class ChassisIpmiCmds.GetDeviceCapabilitiesReq
---@field ManufactureId integer
---@field DeviceNum integer
---@field ReadLen integer
---@field ReadOffset integer
---@field Devices string
local TGetDeviceCapabilitiesReq = {}
TGetDeviceCapabilitiesReq.__index = TGetDeviceCapabilitiesReq
TGetDeviceCapabilitiesReq.group = {}

local function TGetDeviceCapabilitiesReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceCapabilitiesReq)
end

function TGetDeviceCapabilitiesReq.new(ManufactureId, DeviceNum, ReadLen, ReadOffset, Devices)
    return TGetDeviceCapabilitiesReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNum = DeviceNum,
        ReadLen = ReadLen,
        ReadOffset = ReadOffset,
        Devices = Devices
    })
end
---@param obj ChassisIpmiCmds.GetDeviceCapabilitiesReq
function TGetDeviceCapabilitiesReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNum = obj.DeviceNum
    self.ReadLen = obj.ReadLen
    self.ReadOffset = obj.ReadOffset
    self.Devices = obj.Devices
end

function TGetDeviceCapabilitiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceCapabilitiesReq.group)
end

TGetDeviceCapabilitiesReq.from_obj = TGetDeviceCapabilitiesReq_from_obj

TGetDeviceCapabilitiesReq.proto_property = {'ManufactureId', 'DeviceNum', 'ReadLen', 'ReadOffset', 'Devices'}

TGetDeviceCapabilitiesReq.default = {0, 0, 0, 0, ''}

TGetDeviceCapabilitiesReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNum', is_array = false, struct = nil},
    {name = 'ReadLen', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Devices', is_array = false, struct = nil}
}

function TGetDeviceCapabilitiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNum', self.DeviceNum, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadLen', self.ReadLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Devices', self.Devices, 'string', false, errs, need_convert)

    TGetDeviceCapabilitiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceCapabilitiesReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceCapabilitiesReq:unpack(_)
    return self.ManufactureId, self.DeviceNum, self.ReadLen, self.ReadOffset, self.Devices
end

GetDeviceCapabilities.GetDeviceCapabilitiesReq = TGetDeviceCapabilitiesReq

---@class ChassisIpmiCmds.GetDeviceCapabilitiesRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndFlag integer
---@field InfoLen integer
---@field Capabilities string
local TGetDeviceCapabilitiesRsp = {}
TGetDeviceCapabilitiesRsp.__index = TGetDeviceCapabilitiesRsp
TGetDeviceCapabilitiesRsp.group = {}

local function TGetDeviceCapabilitiesRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceCapabilitiesRsp)
end

function TGetDeviceCapabilitiesRsp.new(CompletionCode, ManufactureId, EndFlag, InfoLen, Capabilities)
    return TGetDeviceCapabilitiesRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndFlag = EndFlag,
        InfoLen = InfoLen,
        Capabilities = Capabilities
    })
end
---@param obj ChassisIpmiCmds.GetDeviceCapabilitiesRsp
function TGetDeviceCapabilitiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndFlag = obj.EndFlag
    self.InfoLen = obj.InfoLen
    self.Capabilities = obj.Capabilities
end

function TGetDeviceCapabilitiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceCapabilitiesRsp.group)
end

TGetDeviceCapabilitiesRsp.from_obj = TGetDeviceCapabilitiesRsp_from_obj

TGetDeviceCapabilitiesRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndFlag', 'InfoLen', 'Capabilities'}

TGetDeviceCapabilitiesRsp.default = {0, 0, 0, 0, ''}

TGetDeviceCapabilitiesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndFlag', is_array = false, struct = nil}, {name = 'InfoLen', is_array = false, struct = nil},
    {name = 'Capabilities', is_array = false, struct = nil}
}

function TGetDeviceCapabilitiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndFlag', self.EndFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InfoLen', self.InfoLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Capabilities', self.Capabilities, 'string', false, errs, need_convert)

    TGetDeviceCapabilitiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceCapabilitiesRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceCapabilitiesRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndFlag, self.InfoLen, self.Capabilities
end

GetDeviceCapabilities.GetDeviceCapabilitiesRsp = TGetDeviceCapabilitiesRsp

return GetDeviceCapabilities
