# chassis 机框管理

# 1、功能简介
本组件主要包括7大功能特性：
（1）整机状态管理：包括开箱事件检测、UID按钮事件上报、统计设备数量及设备可插最大数量、整机状态统计；
（2）I2cLed灯控制：为装备测试提供手段控制I2cLed灯的状态；
（3）Led灯控制：包括控制UID灯的状态、基于当前告警控制健康灯颜色变化；
（4）Led数码管显示：基于当前告警，在数码管上显示相应错误码；
（5）度量数据采集：向`metric_analyzer`组件提供入风口和出风口温度数据；
（6）读取设备配置能力：当前仅支持读取PCIe标卡NCSI线缆是否在位、主板对PCIe标卡NCSI功能是否支持；
（7）超节点属性配置与获取：superpodid、server index、npu 规模(superpod size)并通过CPLD传递给芯片。

# 2、关键特性
## 2.1 整机状态管理
### 2.1.1 开箱事件检测
`Chassis`组件启动之后，会开启常驻协程用于更新开箱标志，当通过smc命令字检测到开箱事件之后会将`IntrusionFlag`设置为1，触发开箱事件。
拥有下电开箱事件上报则说明寄存器支持下电时记录开箱，上电后将寄存器中的值与当前状态作比较即可指导有无关箱。
上电时与之前一次（在数据库中持久化，可以横跨一次下电）上电开箱状态改变时的状态做比较，如果由关箱变为开箱则上报开箱；如果由上电开箱状态为有过上电开箱但目前状态为关箱则认为发生上电关箱。
开箱事件检测流程图如下：
![开箱事件流程图](http://image.huawei.com/tiny-lts/v1/images/90faba68eb93dfd7595f920a149b80b1_602x703.png@900-0-90-f.png)

### 2.1.2 UID按钮事件上报
UID按钮事件分为UID短按事件与UID长按事件。
UID短按会将UID灯的亮灭状态进行转换，长按复位BMC。
UID短按实现方案如下：
 ![短按](https://image.huawei.com/tiny-lts/v1/images/439b7f5522f7efe058efde7af47f43be_474x676.png@900-0-90-f.png)
短按事件是基于属性监听的机制实现的，但是UID长按会导致BMC直接复位，所以不能通过属性监听的机制实现。
UID长按事件的检测时机是在BMC启动之后，会检查SMC命令字，如果获取1，则表示存在长按事件则上报。

### 2.1.3 统计设备数量及设备可插最大数量
统计方法如下：
组件名称                     数量获取
CPU                     遍历资源树上所有CPU

Memory                  遍历资源树上加载的内存对象

PCIe                    遍历所有Connector对象，记录Type为PCIe的数量

Disk                    1、获取真实的硬盘个数
                        2、获取硬盘背板上槽位数和
                        3、取1和2中最大值+SATADOM和M.2硬盘的个数

Psu                     1、遍历所有connector对象，记录Type为Ps的数量
                        2、获取所有OnePower对象，记录数量
                        3、取其中最大值为最大数量

Fan                     获取所有风扇对象数量

SecurityModule          默认为1

### 2.1.4 整机状态统计
具体方案如下：
该接口会按顺序获取：
1、开机策略；
2、电源故障信息；
3、uid状态；
4、风扇健康状态；
5、硬盘健康状态等信息。
具体流程如下：
 ![整机](https://image.huawei.com/tiny-lts/v1/images/a950d248cdbac2f29c4620eff94ecd66_749x1298.png@900-0-90-f.png)

# 3、对外接口
### 资源树接口
``` 
/bmc/kepler/Systems/{SystemId}/Leds/{Id}
bmc.kepler.Systems.Led              interface -           -                    -
.SetState                           method    a{ss}yy     yyy                  -    # 设置LED灯状态
/bmc/kepler/Chassis/{ChassisId}
bmc.kepler.Metric                   interface -           -                    -
.GetData                            method    a{ss}as     a(sas)               -    # 获取进风口出风口温度
.GetItems                           method    a{ss}       sa(ss)a(ss)as        -    # 获取所度量数据项
/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel
bmc.kepler.Chassis.SuperPodLabel    interface -           -                    -
.SetSuperPodId                      method    a{ss}u      b                    -    # 设置超节点id
.SetServerIndex                     method    a{ss}q      b                    -    # 设置超节点中服务器编号
.SetSuperPodSize                    method    a{ss}q      b                    -    # 设置超节点规模
.RestoreDefaults                    method    a{ss}       b                    -    # 恢复超节点默认设置

```
### IPMI接口
```
├─/bmc/kepler/IpmiCmds
│ ├─/bmc/kepler/IpmiCmds/00
│ │ ├─/bmc/kepler/IpmiCmds/00/01
│ │ │ └─/bmc/kepler/IpmiCmds/00/01/GetPowerCmd                  # 获取机框状态
│ │ └─/bmc/kepler/IpmiCmds/00/04
│ │   └─/bmc/kepler/IpmiCmds/00/04/ChassisIdentify              # 识别机框
│ ├─/bmc/kepler/IpmiCmds/2C
│ │ ├─/bmc/kepler/IpmiCmds/2C/06
│ │ │ └─/bmc/kepler/IpmiCmds/2C/06/GetLedColorCapabilities      # 获取机框颜色能力
│ │ └─/bmc/kepler/IpmiCmds/2C/07
│ │   └─/bmc/kepler/IpmiCmds/2C/07/SetFruLedState               # 设置LED状态
│ └─/bmc/kepler/IpmiCmds/30
│   ├─/bmc/kepler/IpmiCmds/30/92
│   │ ├─/bmc/kepler/IpmiCmds/30/92/GetDeviceCapabilities        # 获取设备能力
│   │ └─/bmc/kepler/IpmiCmds/30/92/SetDeviceCapabilities        # 设置设备能力
│   └─/bmc/kepler/IpmiCmds/30/94
│     └─/bmc/kepler/IpmiCmds/30/94/GetChassisHeight             # 获取机框高度
```

# 4、配置介绍
不涉及组件配置