-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_factory = require 'factory.bios_factory'
local bios_service = require 'service.bios_service'
local ipmi = require 'ipmi'
local comp_code = ipmi.types.Cc
local lu = require 'luaunit'
local bs_util = require 'util.base_util'
local defs = require 'domain.alarm.defs'

local test_common = require 'test_common.utils'
local bus = test_common.dbus_launch('../.dbus', nil, true)

TestReportAlarm = {}


local function construct_ctx()
    local ctx = {}
    ctx.get_initiator = function()
        return {}
    end

    return ctx
end

function TestReportAlarm:test_report_power_link_alarm()
    local ctx = construct_ctx()
    local req = {}
    req.ManufactureId = bios_service:get_manu_id()
    req.EventType = 0x80
    req.AlarmType = 0
    req.Info =  bs_util.struct_to_binary({
        CpuId = 1,
        TypeId = 1,
        DieId = 1,
        ChannelId = 1
    }, '<<CpuId, TypeId, DieId, ChannelId>>')
    bios_service:report_alarm(defs.DeviceId.PSU, req, ctx)
end

function TestReportAlarm:test_report_memory_link_alarm()
    local ctx = construct_ctx()
    local req = {}
    req.ManufactureId = bios_service:get_manu_id()
    req.EventType = 0x80
    req.AlarmType = 1
    req.Info = bs_util.struct_to_binary({
        CpuId = 1,
        ChannelId = 1,
        DIMMId = 1
    }, '<<CpuId, ChannelId, DIMMId>>')
    bios_service:report_alarm(defs.DeviceId.PSU, req, ctx)
end

function TestReportAlarm:test_report_vr_alarm()
    local ctx = construct_ctx()
    bios_service:set_cpu_die({
        IdRange = {0, 1, 2, 3},
        NameRange = {'NA', 'TA', 'NB', 'TB'}
    })

    local req = {}
    req.ManufactureId = bios_service:get_manu_id()
    req.EventType = 0x80
    req.AlarmType = 0

    req.Info = bs_util.struct_to_binary({
        CpuId = 1,
        TypeId = 1,
        DieId = 1
    }, '<<CpuId, TypeId, DieId>>')

    bios_service:report_alarm(defs.DeviceId.VR, req, ctx)
end
