-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local test_bios_ipmi = {}
require 'ipmi'
local log = require 'mc.logging'
local lu = require 'luaunit'
local test_bios_common = require 'test_bios_common'

require 'bios.json_types.BootOptions'
require 'bios.json_types.Bios'

local function send_ipmi(data)
    return test_bios_common.send_ipmi(data)
end

function test_bios_ipmi.test_get_info_param()
    local ok, _ = send_ipmi('0x06 0x59 0x01 0x00 0x00 0x00')
    lu.assertEquals(ok, false)

    local ret, str = send_ipmi('0x06 0x59 0x01 0x01 0x00 0x00')
    lu.assertEquals(ret, true)
    lu.assertEquals(#str, 8)
    lu.assertEquals(string.sub(str, 5, 8), '1.86')

    ok, _ = send_ipmi('0x06 0x59 0x01 0x02 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x59 0x01 0x03 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x59 0x01 0x04 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x59 0x01 0x05 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x59 0x01 0x06 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x59 0x01 0x07 0x00 0x00')
    lu.assertEquals(ok, false)
end

function test_bios_ipmi.test_set_info_param()
    local ok, _ = send_ipmi('0x06 0x58 0x01 0x00 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x58 0x01 0x01 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x58 0x01 0x02 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x58 0x01 0x03 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x58 0x01 0x04 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x58 0x01 0x05 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x58 0x01 0x06 0x00 0x00')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x06 0x58 0x01 0x07 0x00 0x00')
    lu.assertEquals(ok, false)
end

function test_bios_ipmi.update_post_status()
    local ok, _ = send_ipmi('0x30 0x92 0xdb 0x06 0x00 0x00 0x05 0x10 0x01')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x05 0x10 0x05')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x05 0x10')
    lu.assertEquals(ok, false)

    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x05 0x10 0x01')
    lu.assertEquals(ok, true)
end

function test_bios_ipmi.test_bios_set_file_changed()
    -- manu_id非法
    local ok, _ = send_ipmi('0x30 0x92 0xdb 0x06 0x00 0x00 0x0B 0x00 0x00 0x00 0x00')
    lu.assertEquals(ok, false)

    -- bios_id非法
    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x0B 0x01 0x00 0x00 0x00')
    lu.assertEquals(ok, false)

    -- file_selector非法
    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x0B 0x00 0x36 0x00 0x00')
    lu.assertEquals(ok, false)

    -- 正常
    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x0B 0x00 0x00 0x00 0x00')
    lu.assertEquals(ok, true)
end

function test_bios_ipmi.test_add_bios_log_entry()
    -- manu_id非法
    local ok, _ = send_ipmi('0x30 0x92 0xdb 0x06 0x00 0x00 0x0F 0x00 0x00')
    lu.assertEquals(ok, false)

    -- event_type非法
    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x0F 0x05 0x61 0x2C 0x62 0x2C 0x63')
    lu.assertEquals(ok, false)

    -- event_type:1, [a,b,c]
    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x0F 0x00 0x61 0x2C 0x62 0x2C 0x63')
    lu.assertEquals(ok, true)

    -- event_type:2, [a,b,c]
    ok, _ = send_ipmi('0x30 0x92 0xdb 0x07 0x00 0x0F 0x01 0x61 0x2C 0x62 0x2C 0x63')
    lu.assertEquals(ok, true)
end

function test_bios_ipmi.test_ipmi()
    log:info('================ test bios ipmi start ================')
    test_bios_ipmi.test_get_info_param()
    test_bios_ipmi.test_set_info_param()
    test_bios_ipmi.update_post_status()
    test_bios_ipmi.test_bios_set_file_changed()
    test_bios_ipmi.test_add_bios_log_entry()
    log:info('================ test bios ipmi end ================')
end

return test_bios_ipmi
