-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local log = require 'mc.logging'
local prop_def = require 'macros.property_def'
local error_engineer = require 'handler.error_engineer'

local abstract_check = class()

local error_deal_map = {
    [prop_def.REGRIST_TYPE_PROP_NOT_LIST] = function(...)
        error_engineer.set_error(prop_def.REGRIST_TYPE_PROP_NOT_LIST, ...)
    end,
    [prop_def.REGRIST_TYPE_PROP_LENGTH_ERR] = function(...)
        error_engineer.set_error(prop_def.REGRIST_TYPE_PROP_LENGTH_ERR, ...)
    end,
    [prop_def.REGRIST_TYPE_PROP_NOT_RANGE] = function(...)
        error_engineer.set_error(prop_def.REGRIST_TYPE_PROP_NOT_RANGE, ...)
    end,
    [prop_def.REGRIST_TYPE_PROP_TYPE_ERROR] = function(...)
        error_engineer.set_error(prop_def.REGRIST_TYPE_PROP_TYPE_ERROR, ...)
    end,
    [prop_def.REGRIST_TYPE_PROP_SCALAR_INCREMENT] = function(...)
        error_engineer.set_error(prop_def.REGRIST_TYPE_PROP_SCALAR_INCREMENT, ...)
    end
}

function abstract_check:is_config_valid(attribute, value)
    if attribute == nil or value == nil then
        log:error("abstract_check:is_config_valid param error.")
        return prop_def.E_FAILURE
    end

    local res = self.check_type(attribute, value)
    if res == prop_def.E_OK then
        return res
    end
    local error_fun = error_deal_map[res]
    if error_fun == nil then
        error_engineer.set_error(prop_def.REGRIST_INTERNEL_ERROR)
        return res
    end

    local log_name = 'Attributes/'
    local attr_name = attribute:get_val_by_name(prop_def.REGRIST_PROP_ATTRIBUTENAME)
    if attr_name ~= nil then
        log_name = log_name .. attr_name
    end
    local err_val = value
    if type(value) == 'userdata' then
        err_val = 'null'
    end
    error_fun(err_val, log_name)
    return res
end

function abstract_check.check_type(attribute, value)
end

return abstract_check