-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local file_op = require 'service.file.file_operation'
local prop_global = require 'macros.property_global'
local log = require 'mc.logging'
local bios_enum = require 'bios.types.enums'
local bs_util = require 'util.base_util'
local file_sec = require 'utils.file'
local utils_core = require 'utils.core'
local utils = require 'mc.utils'

local OperationImpl = {}

-- 以下为写文件时的操作
local TOperationMenuData = class(file_op)
function TOperationMenuData.write_data(bios_obj, file_selector, data_opt)
end

OperationImpl.OperationMenuData = TOperationMenuData

local TOperationClp = class(file_op)
function TOperationClp.write_data(bios_obj, file_selector, data_opt)
end

OperationImpl.OperationClp = TOperationClp

local TOperationSecureBoot = class(file_op)
function TOperationSecureBoot.write_data(bios_obj, file_selector, data_opt)
    log:notice('[bios] write file: start write current secureboot file.')
    local current_path = bios_obj:get_prop('SecureBootCurrentFile')
    local new_path = bios_obj:get_prop('SecureBootNewFile')
    bs_util.clear_file(current_path)
    bs_util.write_file_data(current_path, data_opt:get_buf())
    bs_util.clear_file(new_path)
    utils_core.chmod_s(current_path, utils.S_IRUSR | utils.S_IWUSR) -- 修改权限为600
    utils_core.chmod_s(new_path, utils.S_IRUSR | utils.S_IWUSR) -- 修改权限为600
    return bios_enum.BiosErrCode.BIOS_ERR_NORMALLY:value()
end

OperationImpl.OperationSecureBoot = TOperationSecureBoot

local TOperationFile = class(file_op)
function TOperationFile.write_data(bios_obj, file_selector, data_opt)
    local len = #prop_global.G_FILE_PROPERTY_NAME
    local real_file_selector = file_selector + 1
    if real_file_selector > len then
        log:error("write_file_finish: file_selector(%u) is out of range", file_selector)
        local err_code = bios_enum.BiosErrCode.BIOS_ERR_IV_LEN:value()
        return err_code
    end

    local file_prop = prop_global.G_FILE_PROPERTY_NAME[real_file_selector]
    local file_name = bios_obj:get_prop(file_prop)
    if not file_name then
        log:error("write_file_finish: file_selector(%u) get fileName fail", file_selector)
        local err_code = bios_enum.BiosErrCode.BIOS_ERR_INVALID_STATUS:value()
        return err_code
    end

    local file = file_sec.open_s(file_name, "w+b")
    if not file then
        log:error("write_file_finish: open %s file fail!", file_selector)
        local err_code = bios_enum.BiosErrCode.BIOS_ERR_FM_FAIL:value()
        return err_code
    end

    file:write(data_opt:get_buf())
    file:flush()
    file:close()

    log:notice("write_file_finish: write file len(%d)!", #data_opt:get_buf())
    local err_code = bios_enum.BiosErrCode.BIOS_ERR_NORMALLY:value()
    return err_code
end

OperationImpl.OperationFile = TOperationFile

return OperationImpl