-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local struct_def = {}

local bios_file_Change_s = class()

function bios_file_Change_s:ctor(db)
    self.db = db
    self.FileNum = db['FileNum'] or 0
    self.FileChangeFlag = db['FileChangeFlag'] or 0
    self.FileChannel = db['FileChannel'] or 0
end

function bios_file_Change_s:get_prop(prop)
    return self[prop]
end

function bios_file_Change_s:set_prop(prop, val)
    self[prop] = val
    local db_obj = self.db
    if db_obj and db_obj[prop] then
        db_obj[prop] = val
        db_obj:save()
    end
end

struct_def.bios_file_Change = bios_file_Change_s

local bios_data_operator_s = class()

function bios_data_operator_s:ctor()
    self.data_flag = 0
    self.data_len = 0
    self.data_offset = 0
    self.data_buf = nil
end

struct_def.bios_data_operator = bios_data_operator_s

return struct_def