-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local initiator = require 'mc.initiator'
local context = class()

-- 由于ipmi_ctx与rpc_ctx不一样,需要转换下
function context:ctor(ipmi_ctx)
    self.ctx = ipmi_ctx
end

local desc = {'HMM', 'ME', 'MMC', 'HOST', 'LAN'}

function context:get_initiator()
    local client
    local ctx = self.ctx
    local from = ctx.from
    if not from then
        client = desc[ctx.ChanType + 1] or 'N/A'  -- 适配lua数组索引从1开始
    else
        client = string.format('%d.%d.%d.%d', string.unpack('I1I1I1I1', ctx.from:sub(-4)))
    end

    local user = 'N/A'
    if ctx.session and ctx.session.user then
        user = ctx.session.user.name or user
    end

    return initiator.new('IPMI', user, client)
end

return context