-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local abstract_cfg = require "pojo.boot.abstract_boot_option"
local boot_def = require "macros.boot_def"

local boot_partition_selector = class(abstract_cfg)

function boot_partition_selector:ctor(option_db_obj, system_id)
    boot_partition_selector.super.init_db_info(self, option_db_obj,
        boot_def.SERVICE_PARTITION_SELECTOR, boot_def.SERVICE_PARTITION_SELECTOR_LOG, system_id)
end

-- 设置启动参数
function boot_partition_selector:operate_info(config_data)
    self.data[0] = string.sub(config_data, 1, 1):byte()
    return boot_def.COMP_CODE_SUCCESS
end

return boot_partition_selector