-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local abstract_cfg = require "pojo.boot.abstract_boot_option"
local boot_def = require "macros.boot_def"
local log = require "mc.logging"

local boot_initiator_info = class(abstract_cfg)

function boot_initiator_info:ctor(option_db_obj, system_id)
    boot_initiator_info.super.init_db_info(self, option_db_obj,
        boot_def.BOOT_INITIATOR_INFO, boot_def.BOOT_INITIATOR_INFO_LOG, system_id)
end

-- 设置启动参数
function boot_initiator_info:operate_info(config_data)
    for i = 1, boot_def.BIOS_BOOT_INIT_INFO_NUM do
        local bin_byte = string.sub(config_data, i, i):byte()
        self.data[i - 1] = bin_byte
        log:info("boot_initiator_info[%d]: %d", i - 1, bin_byte)
    end

    return boot_def.COMP_CODE_SUCCESS
end

return boot_initiator_info