-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local object_def = {}

-- 资源树服务名宏定义 BEGIN
object_def.PCIE_DEVICE_SERVICE_NAME = 'bmc.kepler.pcie_device'
object_def.COMPUTE_SERVICE_NAME = 'bmc.kepler.compute'
object_def.POWERMGMT_SERVICE_NAME = 'bmc.kepler.power_mgmt'
-- 资源树服务名宏定义 END

-- PcieAddrInfo资源树宏定义 BEGIN
object_def.PCIE_ADDR_INFO_PATH = '/bmc/kepler/Systems/1/PCIeDevices/PcieAddrInfo'
object_def.PCIE_ADDR_INFO_INTERFACE = 'bmc.kepler.Systems.PcieAddrInfo'
object_def.PCIE_ADDR_INFO_COMPONENT_TYPE = "ComponentType"
object_def.PCIE_ADDR_INFO_CONTROLLER_TYPE = "ControllerType"
object_def.PCIE_ADDR_INFO_CONTROLLER_TYPE_SAS = 2
object_def.PCIE_ADDR_INFO_CONTROLLER_TYPE_SATA = 3
object_def.MEMORY_INFO_INTERFACE = 'bmc.kepler.Systems.Memory'
object_def.MEMORY_CHANNEL_INTERFACE = 'bmc.kepler.Systems.MemoryChannel'
object_def.STORAGE_SERVICE = 'bmc.kepler.storage'
object_def.ADDRINFO_INTERFACE = 'bmc.kepler.Systems.Storage.Drive.AddrInfo'
object_def.PCIE_ADDR_INFO_SEGMENT = "Segment"
object_def.PCIE_ADDR_INFO_BUS = "Bus"
object_def.PCIE_ADDR_INFO_DEVICE = "Device"
object_def.PCIE_ADDR_INFO_SOCKET_ID = "SocketID"
object_def.PCIE_ADDR_INFO_DEVICE_PORT_ID = "PortID"
object_def.PCIE_ADDR_INFO_FUNCTION = "Function"
object_def.PCIE_ADDR_INFO_SLOT_ID = "SlotID"
object_def.PROPERTY_DISK_ADDR_INFO_PHY_ID = "PhysicalID"
object_def.PROPERTY_DISK_ADDR_INFO_CONTROL_ID = "ControllerIndex"
object_def.PROPERTY_MEM_NAME = "DimmName"
object_def.PROPERTY_MEM_CPU_ID = "CpuId"
object_def.PROPERTY_MEM_CHANNEL_ID = "ChannelId"
object_def.PROPERTY_MEM_DIMM_ID = "DimmId"
object_def.PROPERTY_PHYSICAL_CHANNEL_ID = "PhysicalChannelId"
object_def.PROPERTY_LOGICAL_CHANNEL_ID = "LogicalChannelId"
-- PcieAddrInfo资源树属宏定义 END

object_def.BOOT_SOURCE_OVERRIDE_MODE = 'BootSourceOverrideMode'
object_def.BOOT_SOURCE_OVERRIDE_TARGET = 'BootSourceOverrideTarget'
object_def.BOOT_SOURCE_OVERRIDE_ENABLED = 'BootSourceOverrideEnabled'
object_def.BIOS_BOOT_MODE_SUPPORT = 'BootModeSupport'
object_def.BIOS_BOOT_MODE = 'BiosBootMode'
object_def.BIOS_BOOT_MODE_SW = 'BootModeIpmiSettable'

object_def.BIOS_NAME = 'Bios'
object_def.RESET_CMOS_PROP = 'ResetCmos'
object_def.SOC_PROP = 'Soc'

object_def.PROPERTY_BIOS_SETUP_PWD_OLD = "OldSetupPassword"
object_def.PROPERTY_BIOS_SETUP_PWD_NEW = "NewSetupPassword"
object_def.PROPERTY_BIOS_USER_SETUP_PWD_OLD = "UserOldSetupPassword"
object_def.PROPERTY_BIOS_USER_SETUP_PWD_NEW = "UserNewSetupPassword"

object_def.POWER_STATUS_INTERFACE = 'bmc.kepler.Systems.PowerMgmt.OnePower.Status'
object_def.ONE_POWER_INTERFACE = 'bmc.kepler.Systems.PowerMgmt.OnePower'
object_def.METRICS_INTERFACE = 'bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'

-- ControllerType是PCIe控制器类型（0:PCIeCore，1:NIC，2:SAS，3:SATA，4:ZIP，5:SEC），用于向bios上报丝印信息时区分不同设备
-- 丝印信息要求ControlId: Sata是2，Sas是0/1
object_def.controller_type_to_control_id = {
  [2] = 1,    -- SAS
  [3] = 2     -- SATA
}

return object_def