-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'

local chain = class()

function chain:ctor()
    self.chain = {}
    self.index = 1
end

-- 任务链添加任务和回调
-- 回调可以处理任务输出的数据、异常等
function chain:add(executor)
    if not executor then
        return
    end
    self.chain[#self.chain + 1] = executor
end

-- 任务链执行
function chain:execute(ctx)
    local index = self.index
    if index > #self.chain then
        self.chain = {}
        self.index = 1
        return
    end
    local executor = self.chain[index]
    self.index = self.index + 1
    local ok, err = pcall(function()
        return executor:execute(ctx, self)
    end)
    if not ok then
        return err
    end
end

return chain
