-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local prop_def = require 'macros.property_def'

local start_option_handler = {}

local function judge_data(data)
    if not data or not data[1] or type(data[1]) ~= prop_def.NUMBER_TYPE then
        return false
    end

    return true
end

local t_option_handler = class()
function t_option_handler.handle(data, start_option)
    if not judge_data(data) or not start_option then
        return false
    end

    local start_option_cfg = (start_option & 0x0f) << 2
    local other_cfg = data[1] & 0xc3
    data[1] = start_option_cfg | other_cfg
    return true
end

start_option_handler.option_handler = t_option_handler

return start_option_handler