-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 固件相关的基类
local class = require 'mc.class'
local imu = require 'infrastructure.imu'

local ComponentCommunicate = class()

function ComponentCommunicate:ctor()
    self.imu_cmd = imu.get_instance()
    self.defs = {
        netfn = {
            OemReqNetfn = 0x30
        },
        cmd = {
            ImuCmd = 0x98
        }
    }
end

function ComponentCommunicate:retry_send_and_receive_msg(msg)
    local ok, res
    for _ = 1, 3 do
        ok, res = pcall(self.imu_cmd.send_and_receive, self.imu_cmd, msg)
        if ok then
            return res
        end
    end
    error(string.format("[bios]retry_send_and_receive_msg failed, cmd:%s, err:%s", msg.Header.Cmd, res))
end

function ComponentCommunicate:retry_send_msg(msg)
    local ok, res
    for _ = 1, 3 do
        ok, res = pcall(self.imu_cmd.send, self.imu_cmd, msg)
        if ok then
            return res
        end
    end
    error(string.format("[bios]retry_send_msg failed, cmd:%s, err:%s", msg.Header.Cmd, res))
end

return ComponentCommunicate