-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local defs = {}

defs.UpgradeEvent = {
    UpgradeReady = 1,
    PrepareStart = 2,
    PrepareFinish = 3,
    ProcessStart = 4,
    ProcessFinish = 5,
    FimwareStart = 6,
    FimwareFinish = 7,
    Error = 8
}

defs.PfrVerify = {
    Success = 0,
    Failed = 1
}

defs.UpgradeMode = {
    Cold = 0,
    Hot = 1,
    Force = 2,
    PowerOffEffective = 3,
    OnlineForce = 4
}

defs.UpgradeModeStr = {
    [defs.UpgradeMode.Cold] = 'Cold',
    [defs.UpgradeMode.Hot] = 'Hot',
    [defs.UpgradeMode.Force] = 'Force',
    [defs.UpgradeMode.PowerOffEffective] = 'PowerOffEffective',
    [defs.UpgradeMode.OnlineForce] = 'OnlineForce'
}

defs.PackagePeriod = {
    Period2 = 0,
    Period3 = 1
}

defs.PackagePeriodStr = {
    [defs.PackagePeriod.Period2] = 'Period2',
    [defs.PackagePeriod.Period3] = 'Period3'
}

defs.PackageType = {
    Normal = 0,
    Patch = 1,
    Tee = 2
}

defs.PackageTypeStr = {
    [defs.PackageType.Normal] = 'Normal',
    [defs.PackageType.Patch] = 'Patch',
    [defs.PackageType.Tee] = 'Tee'
}

defs.UpgradeFlag = {
    Start = 0,
    Finish = 1
}

defs.UpgradePhrase = {
    Before = 'Before',
    Process = 'Process',
    After = 'After'
}

defs.UpgradeSteps = {
    PackageCheck = 'PackageCheck',-- 默认
    Backup  = 'Backup',-- 默认
    Cache = 'Cache',
    ForcePower = 'ForcePower',
    LockPower = 'LockPower',-- 默认
    SpiDriver = 'SpiDriver',
    DecompressFile = 'DecompressFile',-- 默认
    ParserBin = 'ParserBin',-- 默认
    ComponentFilter = 'ComponentFilter',
    SelectChannel = 'SelectChannel',-- 默认
    UpgradeComponent = 'UpgradeComponent',-- 默认,
    WaitUpgradeFinish = 'WaitUpgradeFinish',
    ActivateFirmware = 'ActivateFirmware'
}

defs.UpgradeStepIndex = {
    [1] = defs.UpgradeSteps.PackageCheck,
    [2] = defs.UpgradeSteps.Backup,
    [3] = defs.UpgradeSteps.Cache,
    [4] = defs.UpgradeSteps.ForcePower,
    [5] = defs.UpgradeSteps.LockPower,
    [6] = defs.UpgradeSteps.SpiDriver,
    [7] = defs.UpgradeSteps.DecompressFile,
    [8] = defs.UpgradeSteps.ParserBin,
    [9] = defs.UpgradeSteps.ComponentFilter,
    [10] = defs.UpgradeSteps.SelectChannel,
    [11] = defs.UpgradeSteps.UpgradeComponent,
    [12] = defs.UpgradeSteps.WaitUpgradeFinish
}

defs.ReadImuFileType = {
    ComponentVersion = 0x00,
    BiosFirmware = 0x01,
    BiosFirmwareHead = 0x02,
    Registery = 0x03,
    Current = 0x04
}

defs.ActivateStatus = {
    Begin = 0x00,
    Running = 0x01,
    Finish = 0x02
}

defs.BiosActiveRegisterList = {
    {Key = 'FirmwareId', Value = 'BIOS'},
    {Key = 'FirmwareType', Value = 'BIOS'},
    {Key = 'ActiveCondition', Value = 'PowerOff'},
    {Key = 'ActiveMode', Value = 'None'},
    {Key = 'ActiveStatus', Value = 'Idle'}
}

defs.SINGLE_HOST_SYSTEM_ID  = 1
defs.ALL_HOST_SYSTEM_ID     = 255

defs.FirmwareEffectiveStatus = {
    UnEffective = 0x01,   --（待生效）固件待写入flash
    Effecting = 0x02,     -- 生效中
    Effective = 0x03      -- 生效完成
}

defs.FirmwareEffectiveActions = {
    WaitReset = 0x01,       -- 升级后下次重启生效
    Immediately = 0x02,     -- 立即生效，不重启
    ImmediatelyReset = 0x03 -- 立即生效，并且重启
}

defs.UpgradeState = {
    Start = 0,
    UpgradeFailed = 1,
    SyncProcess = 2,
    SyncFailed = 3,
    Success = 4
}

defs.PostResult = {
    Success = 0,
    Failed = 1
}

defs.UpgradeResult = {
    Success = 0,
    Failed = 1
}

return defs