-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBiosUpdateCfgTable = {}

---@class MBiosUpdateCfgTable.SlaveUpgrade
---@field SlaveUpgrade boolean
local TSlaveUpgrade = {}
TSlaveUpgrade.__index = TSlaveUpgrade
TSlaveUpgrade.group = {}

local function TSlaveUpgrade_from_obj(obj)
    return setmetatable(obj, TSlaveUpgrade)
end

function TSlaveUpgrade.new(SlaveUpgrade)
    return TSlaveUpgrade_from_obj({SlaveUpgrade = SlaveUpgrade or false})
end
---@param obj MBiosUpdateCfgTable.SlaveUpgrade
function TSlaveUpgrade:init_from_obj(obj)
    self.SlaveUpgrade = obj.SlaveUpgrade or false
end

function TSlaveUpgrade:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlaveUpgrade.group)
end

TSlaveUpgrade.from_obj = TSlaveUpgrade_from_obj

TSlaveUpgrade.proto_property = {'SlaveUpgrade'}

TSlaveUpgrade.default = {false}

TSlaveUpgrade.struct = {{name = 'SlaveUpgrade', is_array = false, struct = nil}}

function TSlaveUpgrade:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlaveUpgrade', self.SlaveUpgrade, 'bool', false, errs, need_convert)

    TSlaveUpgrade:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlaveUpgrade.proto_property, errs, need_convert)
    return self
end

function TSlaveUpgrade:unpack(_)
    return self.SlaveUpgrade
end

MBiosUpdateCfgTable.SlaveUpgrade = TSlaveUpgrade

---@class MBiosUpdateCfgTable.FirmwareEffectiveStatus
---@field FirmwareEffectiveStatus integer
local TFirmwareEffectiveStatus = {}
TFirmwareEffectiveStatus.__index = TFirmwareEffectiveStatus
TFirmwareEffectiveStatus.group = {}

local function TFirmwareEffectiveStatus_from_obj(obj)
    return setmetatable(obj, TFirmwareEffectiveStatus)
end

function TFirmwareEffectiveStatus.new(FirmwareEffectiveStatus)
    return TFirmwareEffectiveStatus_from_obj({FirmwareEffectiveStatus = FirmwareEffectiveStatus})
end
---@param obj MBiosUpdateCfgTable.FirmwareEffectiveStatus
function TFirmwareEffectiveStatus:init_from_obj(obj)
    self.FirmwareEffectiveStatus = obj.FirmwareEffectiveStatus
end

function TFirmwareEffectiveStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareEffectiveStatus.group)
end

TFirmwareEffectiveStatus.from_obj = TFirmwareEffectiveStatus_from_obj

TFirmwareEffectiveStatus.proto_property = {'FirmwareEffectiveStatus'}

TFirmwareEffectiveStatus.default = {0}

TFirmwareEffectiveStatus.struct = {{name = 'FirmwareEffectiveStatus', is_array = false, struct = nil}}

function TFirmwareEffectiveStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareEffectiveStatus', self.FirmwareEffectiveStatus, 'uint8', false, errs,
        need_convert)

    TFirmwareEffectiveStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareEffectiveStatus.proto_property, errs, need_convert)
    return self
end

function TFirmwareEffectiveStatus:unpack(_)
    return self.FirmwareEffectiveStatus
end

MBiosUpdateCfgTable.FirmwareEffectiveStatus = TFirmwareEffectiveStatus

---@class MBiosUpdateCfgTable.Period
---@field Period integer
local TPeriod = {}
TPeriod.__index = TPeriod
TPeriod.group = {}

local function TPeriod_from_obj(obj)
    return setmetatable(obj, TPeriod)
end

function TPeriod.new(Period)
    return TPeriod_from_obj({Period = Period})
end
---@param obj MBiosUpdateCfgTable.Period
function TPeriod:init_from_obj(obj)
    self.Period = obj.Period
end

function TPeriod:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPeriod.group)
end

TPeriod.from_obj = TPeriod_from_obj

TPeriod.proto_property = {'Period'}

TPeriod.default = {0}

TPeriod.struct = {{name = 'Period', is_array = false, struct = nil}}

function TPeriod:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Period', self.Period, 'uint32', false, errs, need_convert)

    TPeriod:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPeriod.proto_property, errs, need_convert)
    return self
end

function TPeriod:unpack(_)
    return self.Period
end

MBiosUpdateCfgTable.Period = TPeriod

---@class MBiosUpdateCfgTable.PackageType
---@field PackageType integer
local TPackageType = {}
TPackageType.__index = TPackageType
TPackageType.group = {}

local function TPackageType_from_obj(obj)
    return setmetatable(obj, TPackageType)
end

function TPackageType.new(PackageType)
    return TPackageType_from_obj({PackageType = PackageType})
end
---@param obj MBiosUpdateCfgTable.PackageType
function TPackageType:init_from_obj(obj)
    self.PackageType = obj.PackageType
end

function TPackageType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPackageType.group)
end

TPackageType.from_obj = TPackageType_from_obj

TPackageType.proto_property = {'PackageType'}

TPackageType.default = {0}

TPackageType.struct = {{name = 'PackageType', is_array = false, struct = nil}}

function TPackageType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PackageType', self.PackageType, 'uint32', false, errs, need_convert)

    TPackageType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPackageType.proto_property, errs, need_convert)
    return self
end

function TPackageType:unpack(_)
    return self.PackageType
end

MBiosUpdateCfgTable.PackageType = TPackageType

---@class MBiosUpdateCfgTable.EffectiveFlag
---@field EffectiveFlag integer
local TEffectiveFlag = {}
TEffectiveFlag.__index = TEffectiveFlag
TEffectiveFlag.group = {}

local function TEffectiveFlag_from_obj(obj)
    return setmetatable(obj, TEffectiveFlag)
end

function TEffectiveFlag.new(EffectiveFlag)
    return TEffectiveFlag_from_obj({EffectiveFlag = EffectiveFlag})
end
---@param obj MBiosUpdateCfgTable.EffectiveFlag
function TEffectiveFlag:init_from_obj(obj)
    self.EffectiveFlag = obj.EffectiveFlag
end

function TEffectiveFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEffectiveFlag.group)
end

TEffectiveFlag.from_obj = TEffectiveFlag_from_obj

TEffectiveFlag.proto_property = {'EffectiveFlag'}

TEffectiveFlag.default = {0}

TEffectiveFlag.struct = {{name = 'EffectiveFlag', is_array = false, struct = nil}}

function TEffectiveFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EffectiveFlag', self.EffectiveFlag, 'uint32', false, errs, need_convert)

    TEffectiveFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEffectiveFlag.proto_property, errs, need_convert)
    return self
end

function TEffectiveFlag:unpack(_)
    return self.EffectiveFlag
end

MBiosUpdateCfgTable.EffectiveFlag = TEffectiveFlag

---@class MBiosUpdateCfgTable.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj MBiosUpdateCfgTable.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

MBiosUpdateCfgTable.Version = TVersion

---@class MBiosUpdateCfgTable.UpgradeFinishFlag
---@field UpgradeFinishFlag boolean
local TUpgradeFinishFlag = {}
TUpgradeFinishFlag.__index = TUpgradeFinishFlag
TUpgradeFinishFlag.group = {}

local function TUpgradeFinishFlag_from_obj(obj)
    return setmetatable(obj, TUpgradeFinishFlag)
end

function TUpgradeFinishFlag.new(UpgradeFinishFlag)
    return TUpgradeFinishFlag_from_obj({UpgradeFinishFlag = UpgradeFinishFlag == nil and true or UpgradeFinishFlag})
end
---@param obj MBiosUpdateCfgTable.UpgradeFinishFlag
function TUpgradeFinishFlag:init_from_obj(obj)
    self.UpgradeFinishFlag = obj.UpgradeFinishFlag == nil and true or obj.UpgradeFinishFlag
end

function TUpgradeFinishFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeFinishFlag.group)
end

TUpgradeFinishFlag.from_obj = TUpgradeFinishFlag_from_obj

TUpgradeFinishFlag.proto_property = {'UpgradeFinishFlag'}

TUpgradeFinishFlag.default = {false}

TUpgradeFinishFlag.struct = {{name = 'UpgradeFinishFlag', is_array = false, struct = nil}}

function TUpgradeFinishFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradeFinishFlag', self.UpgradeFinishFlag, 'bool', false, errs, need_convert)

    TUpgradeFinishFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeFinishFlag.proto_property, errs, need_convert)
    return self
end

function TUpgradeFinishFlag:unpack(_)
    return self.UpgradeFinishFlag
end

MBiosUpdateCfgTable.UpgradeFinishFlag = TUpgradeFinishFlag

---@class MBiosUpdateCfgTable.idex
---@field idex integer
local Tidex = {}
Tidex.__index = Tidex
Tidex.group = {}

local function Tidex_from_obj(obj)
    return setmetatable(obj, Tidex)
end

function Tidex.new(idex)
    return Tidex_from_obj({idex = idex})
end
---@param obj MBiosUpdateCfgTable.idex
function Tidex:init_from_obj(obj)
    self.idex = obj.idex
end

function Tidex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, Tidex.group)
end

Tidex.from_obj = Tidex_from_obj

Tidex.proto_property = {'idex'}

Tidex.default = {0}

Tidex.struct = {{name = 'idex', is_array = false, struct = nil}}

function Tidex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'idex', self.idex, 'uint32', false, errs, need_convert)

    Tidex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, Tidex.proto_property, errs, need_convert)
    return self
end

function Tidex:unpack(_)
    return self.idex
end

MBiosUpdateCfgTable.idex = Tidex

---@class MBiosUpdateCfgTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MBiosUpdateCfgTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MBiosUpdateCfgTable.Id = TId

return MBiosUpdateCfgTable
