-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBiosBootTable = {}

---@class MBiosBootTable.BootOrder
---@field BootOrder string
local TBootOrder = {}
TBootOrder.__index = TBootOrder
TBootOrder.group = {}

local function TBootOrder_from_obj(obj)
    return setmetatable(obj, TBootOrder)
end

function TBootOrder.new(BootOrder)
    return TBootOrder_from_obj({BootOrder = BootOrder})
end
---@param obj MBiosBootTable.BootOrder
function TBootOrder:init_from_obj(obj)
    self.BootOrder = obj.BootOrder
end

function TBootOrder:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootOrder.group)
end

TBootOrder.from_obj = TBootOrder_from_obj

TBootOrder.proto_property = {'BootOrder'}

TBootOrder.default = {''}

TBootOrder.struct = {{name = 'BootOrder', is_array = false, struct = nil}}

function TBootOrder:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootOrder', self.BootOrder, 'string', false, errs, need_convert)

    TBootOrder:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootOrder.proto_property, errs, need_convert)
    return self
end

function TBootOrder:unpack(_)
    return self.BootOrder
end

MBiosBootTable.BootOrder = TBootOrder

---@class MBiosBootTable.BootSourceOverrideTarget
---@field BootSourceOverrideTarget string
local TBootSourceOverrideTarget = {}
TBootSourceOverrideTarget.__index = TBootSourceOverrideTarget
TBootSourceOverrideTarget.group = {}

local function TBootSourceOverrideTarget_from_obj(obj)
    return setmetatable(obj, TBootSourceOverrideTarget)
end

function TBootSourceOverrideTarget.new(BootSourceOverrideTarget)
    return TBootSourceOverrideTarget_from_obj({BootSourceOverrideTarget = BootSourceOverrideTarget})
end
---@param obj MBiosBootTable.BootSourceOverrideTarget
function TBootSourceOverrideTarget:init_from_obj(obj)
    self.BootSourceOverrideTarget = obj.BootSourceOverrideTarget
end

function TBootSourceOverrideTarget:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootSourceOverrideTarget.group)
end

TBootSourceOverrideTarget.from_obj = TBootSourceOverrideTarget_from_obj

TBootSourceOverrideTarget.proto_property = {'BootSourceOverrideTarget'}

TBootSourceOverrideTarget.default = {''}

TBootSourceOverrideTarget.struct = {{name = 'BootSourceOverrideTarget', is_array = false, struct = nil}}

function TBootSourceOverrideTarget:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootSourceOverrideTarget', self.BootSourceOverrideTarget, 'string', false, errs,
        need_convert)

    TBootSourceOverrideTarget:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootSourceOverrideTarget.proto_property, errs, need_convert)
    return self
end

function TBootSourceOverrideTarget:unpack(_)
    return self.BootSourceOverrideTarget
end

MBiosBootTable.BootSourceOverrideTarget = TBootSourceOverrideTarget

---@class MBiosBootTable.BootSourceOverrideEnabled
---@field BootSourceOverrideEnabled string
local TBootSourceOverrideEnabled = {}
TBootSourceOverrideEnabled.__index = TBootSourceOverrideEnabled
TBootSourceOverrideEnabled.group = {}

local function TBootSourceOverrideEnabled_from_obj(obj)
    return setmetatable(obj, TBootSourceOverrideEnabled)
end

function TBootSourceOverrideEnabled.new(BootSourceOverrideEnabled)
    return TBootSourceOverrideEnabled_from_obj({BootSourceOverrideEnabled = BootSourceOverrideEnabled})
end
---@param obj MBiosBootTable.BootSourceOverrideEnabled
function TBootSourceOverrideEnabled:init_from_obj(obj)
    self.BootSourceOverrideEnabled = obj.BootSourceOverrideEnabled
end

function TBootSourceOverrideEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootSourceOverrideEnabled.group)
end

TBootSourceOverrideEnabled.from_obj = TBootSourceOverrideEnabled_from_obj

TBootSourceOverrideEnabled.proto_property = {'BootSourceOverrideEnabled'}

TBootSourceOverrideEnabled.default = {''}

TBootSourceOverrideEnabled.struct = {{name = 'BootSourceOverrideEnabled', is_array = false, struct = nil}}

function TBootSourceOverrideEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootSourceOverrideEnabled', self.BootSourceOverrideEnabled, 'string', false, errs,
        need_convert)

    TBootSourceOverrideEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootSourceOverrideEnabled.proto_property, errs, need_convert)
    return self
end

function TBootSourceOverrideEnabled:unpack(_)
    return self.BootSourceOverrideEnabled
end

MBiosBootTable.BootSourceOverrideEnabled = TBootSourceOverrideEnabled

---@class MBiosBootTable.BootSourceOverrideMode
---@field BootSourceOverrideMode string
local TBootSourceOverrideMode = {}
TBootSourceOverrideMode.__index = TBootSourceOverrideMode
TBootSourceOverrideMode.group = {}

local function TBootSourceOverrideMode_from_obj(obj)
    return setmetatable(obj, TBootSourceOverrideMode)
end

function TBootSourceOverrideMode.new(BootSourceOverrideMode)
    return TBootSourceOverrideMode_from_obj({BootSourceOverrideMode = BootSourceOverrideMode})
end
---@param obj MBiosBootTable.BootSourceOverrideMode
function TBootSourceOverrideMode:init_from_obj(obj)
    self.BootSourceOverrideMode = obj.BootSourceOverrideMode
end

function TBootSourceOverrideMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootSourceOverrideMode.group)
end

TBootSourceOverrideMode.from_obj = TBootSourceOverrideMode_from_obj

TBootSourceOverrideMode.proto_property = {'BootSourceOverrideMode'}

TBootSourceOverrideMode.default = {''}

TBootSourceOverrideMode.struct = {{name = 'BootSourceOverrideMode', is_array = false, struct = nil}}

function TBootSourceOverrideMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootSourceOverrideMode', self.BootSourceOverrideMode, 'string', false, errs,
        need_convert)

    TBootSourceOverrideMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootSourceOverrideMode.proto_property, errs, need_convert)
    return self
end

function TBootSourceOverrideMode:unpack(_)
    return self.BootSourceOverrideMode
end

MBiosBootTable.BootSourceOverrideMode = TBootSourceOverrideMode

---@class MBiosBootTable.BootModeIpmiSettable
---@field BootModeIpmiSettable boolean
local TBootModeIpmiSettable = {}
TBootModeIpmiSettable.__index = TBootModeIpmiSettable
TBootModeIpmiSettable.group = {}

local function TBootModeIpmiSettable_from_obj(obj)
    return setmetatable(obj, TBootModeIpmiSettable)
end

function TBootModeIpmiSettable.new(BootModeIpmiSettable)
    return TBootModeIpmiSettable_from_obj({BootModeIpmiSettable = BootModeIpmiSettable})
end
---@param obj MBiosBootTable.BootModeIpmiSettable
function TBootModeIpmiSettable:init_from_obj(obj)
    self.BootModeIpmiSettable = obj.BootModeIpmiSettable
end

function TBootModeIpmiSettable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootModeIpmiSettable.group)
end

TBootModeIpmiSettable.from_obj = TBootModeIpmiSettable_from_obj

TBootModeIpmiSettable.proto_property = {'BootModeIpmiSettable'}

TBootModeIpmiSettable.default = {false}

TBootModeIpmiSettable.struct = {{name = 'BootModeIpmiSettable', is_array = false, struct = nil}}

function TBootModeIpmiSettable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootModeIpmiSettable', self.BootModeIpmiSettable, 'bool', false, errs, need_convert)

    TBootModeIpmiSettable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootModeIpmiSettable.proto_property, errs, need_convert)
    return self
end

function TBootModeIpmiSettable:unpack(_)
    return self.BootModeIpmiSettable
end

MBiosBootTable.BootModeIpmiSettable = TBootModeIpmiSettable

---@class MBiosBootTable.BootModeSupport
---@field BootModeSupport boolean
local TBootModeSupport = {}
TBootModeSupport.__index = TBootModeSupport
TBootModeSupport.group = {}

local function TBootModeSupport_from_obj(obj)
    return setmetatable(obj, TBootModeSupport)
end

function TBootModeSupport.new(BootModeSupport)
    return TBootModeSupport_from_obj({BootModeSupport = BootModeSupport})
end
---@param obj MBiosBootTable.BootModeSupport
function TBootModeSupport:init_from_obj(obj)
    self.BootModeSupport = obj.BootModeSupport
end

function TBootModeSupport:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootModeSupport.group)
end

TBootModeSupport.from_obj = TBootModeSupport_from_obj

TBootModeSupport.proto_property = {'BootModeSupport'}

TBootModeSupport.default = {false}

TBootModeSupport.struct = {{name = 'BootModeSupport', is_array = false, struct = nil}}

function TBootModeSupport:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootModeSupport', self.BootModeSupport, 'bool', false, errs, need_convert)

    TBootModeSupport:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootModeSupport.proto_property, errs, need_convert)
    return self
end

function TBootModeSupport:unpack(_)
    return self.BootModeSupport
end

MBiosBootTable.BootModeSupport = TBootModeSupport

---@class MBiosBootTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MBiosBootTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MBiosBootTable.Id = TId

return MBiosBootTable
