-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local BiosEnum = require 'bios.types.enums'

local BiosMsg = {}

---@class BiosMsg.SetAttributeReq
---@field AttributeName string
---@field AttributeValue string
local TSetAttributeReq = {}
TSetAttributeReq.__index = TSetAttributeReq
TSetAttributeReq.group = {}

local function TSetAttributeReq_from_obj(obj)
    return setmetatable(obj, TSetAttributeReq)
end

function TSetAttributeReq.new(AttributeName, AttributeValue)
    return TSetAttributeReq_from_obj({
        AttributeName = AttributeName,
        AttributeValue = AttributeValue
    })
end
---@param obj BiosMsg.SetAttributeReq
function TSetAttributeReq:init_from_obj(obj)
    self.AttributeName = obj.AttributeName
    self.AttributeValue = obj.AttributeValue
end

function TSetAttributeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAttributeReq.group)
end

TSetAttributeReq.from_obj = TSetAttributeReq_from_obj

TSetAttributeReq.proto_property = {'AttributeName', 'AttributeValue'}

TSetAttributeReq.default = {'', ''}

function TSetAttributeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AttributeName', self.AttributeName, 'string', false, errs)
    validate.Required(prefix .. 'AttributeValue', self.AttributeValue, 'string', false, errs)

    TSetAttributeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAttributeReq.proto_property, errs)
    return self
end

function TSetAttributeReq:unpack(_)
    return self.AttributeName, self.AttributeValue
end

BiosMsg.SetAttributeReq = TSetAttributeReq

---@class BiosMsg.SetAttributeResp
---@field MaxNum string
---@field CurrentNum integer
local TSetAttributeResp = {}
TSetAttributeResp.__index = TSetAttributeResp
TSetAttributeResp.group = {}

local function TSetAttributeResp_from_obj(obj)
    return setmetatable(obj, TSetAttributeResp)
end

function TSetAttributeResp.new(MaxNum, CurrentNum)
    return TSetAttributeResp_from_obj({MaxNum = MaxNum, CurrentNum = CurrentNum})
end
---@param obj BiosMsg.SetAttributeResp
function TSetAttributeResp:init_from_obj(obj)
    self.MaxNum = obj.MaxNum
    self.CurrentNum = obj.CurrentNum
end

function TSetAttributeResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAttributeResp.group)
end

TSetAttributeResp.from_obj = TSetAttributeResp_from_obj

TSetAttributeResp.proto_property = {'MaxNum', 'CurrentNum'}

TSetAttributeResp.default = {'', 0}

function TSetAttributeResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'MaxNum', self.MaxNum, 'string', false, errs)
    validate.Required(prefix .. 'CurrentNum', self.CurrentNum, 'uint32', false, errs)

    TSetAttributeResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAttributeResp.proto_property, errs)
    return self
end

function TSetAttributeResp:unpack(_)
    return self.MaxNum, self.CurrentNum
end

BiosMsg.SetAttributeResp = TSetAttributeResp

---@class BiosMsg.GetAttributeReq
---@field AttributeName string
local TGetAttributeReq = {}
TGetAttributeReq.__index = TGetAttributeReq
TGetAttributeReq.group = {}

local function TGetAttributeReq_from_obj(obj)
    return setmetatable(obj, TGetAttributeReq)
end

function TGetAttributeReq.new(AttributeName)
    return TGetAttributeReq_from_obj({AttributeName = AttributeName})
end
---@param obj BiosMsg.GetAttributeReq
function TGetAttributeReq:init_from_obj(obj)
    self.AttributeName = obj.AttributeName
end

function TGetAttributeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAttributeReq.group)
end

TGetAttributeReq.from_obj = TGetAttributeReq_from_obj

TGetAttributeReq.proto_property = {'AttributeName'}

TGetAttributeReq.default = {''}

function TGetAttributeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AttributeName', self.AttributeName, 'string', false, errs)

    TGetAttributeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAttributeReq.proto_property, errs)
    return self
end

function TGetAttributeReq:unpack(_)
    return self.AttributeName
end

BiosMsg.GetAttributeReq = TGetAttributeReq

---@class BiosMsg.GetAttributeResp
---@field CurrentValue string
---@field PendingValue string
local TGetAttributeResp = {}
TGetAttributeResp.__index = TGetAttributeResp
TGetAttributeResp.group = {}

local function TGetAttributeResp_from_obj(obj)
    return setmetatable(obj, TGetAttributeResp)
end

function TGetAttributeResp.new(CurrentValue, PendingValue)
    return TGetAttributeResp_from_obj({CurrentValue = CurrentValue, PendingValue = PendingValue})
end
---@param obj BiosMsg.GetAttributeResp
function TGetAttributeResp:init_from_obj(obj)
    self.CurrentValue = obj.CurrentValue
    self.PendingValue = obj.PendingValue
end

function TGetAttributeResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAttributeResp.group)
end

TGetAttributeResp.from_obj = TGetAttributeResp_from_obj

TGetAttributeResp.proto_property = {'CurrentValue', 'PendingValue'}

TGetAttributeResp.default = {'', ''}

function TGetAttributeResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'CurrentValue', self.CurrentValue, 'string', false, errs)
    validate.Required(prefix .. 'PendingValue', self.PendingValue, 'string', false, errs)

    TGetAttributeResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAttributeResp.proto_property, errs)
    return self
end

function TGetAttributeResp:unpack(_)
    return self.CurrentValue, self.PendingValue
end

BiosMsg.GetAttributeResp = TGetAttributeResp

---@class BiosMsg.ChangePasswordReq
---@field UserName string
---@field CurrentPassword string
---@field NewPassword string
local TChangePasswordReq = {}
TChangePasswordReq.__index = TChangePasswordReq
TChangePasswordReq.group = {}

local function TChangePasswordReq_from_obj(obj)
    return setmetatable(obj, TChangePasswordReq)
end

function TChangePasswordReq.new(UserName, CurrentPassword, NewPassword)
    return TChangePasswordReq_from_obj({
        UserName = UserName,
        CurrentPassword = CurrentPassword,
        NewPassword = NewPassword
    })
end
---@param obj BiosMsg.ChangePasswordReq
function TChangePasswordReq:init_from_obj(obj)
    self.UserName = obj.UserName
    self.CurrentPassword = obj.CurrentPassword
    self.NewPassword = obj.NewPassword
end

function TChangePasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePasswordReq.group)
end

TChangePasswordReq.from_obj = TChangePasswordReq_from_obj

TChangePasswordReq.proto_property = {'UserName', 'CurrentPassword', 'NewPassword'}

TChangePasswordReq.default = {'', '', ''}

function TChangePasswordReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UserName', self.UserName, 'string', false, errs)
    validate.Required(prefix .. 'CurrentPassword', self.CurrentPassword, 'string', false, errs)
    validate.Required(prefix .. 'NewPassword', self.NewPassword, 'string', false, errs)

    TChangePasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePasswordReq.proto_property, errs)
    return self
end

function TChangePasswordReq:unpack(_)
    return self.UserName, self.CurrentPassword, self.NewPassword
end

BiosMsg.ChangePasswordReq = TChangePasswordReq

---@class BiosMsg.ChangePasswordResp
---@field Result string
local TChangePasswordResp = {}
TChangePasswordResp.__index = TChangePasswordResp
TChangePasswordResp.group = {}

local function TChangePasswordResp_from_obj(obj)
    return setmetatable(obj, TChangePasswordResp)
end

function TChangePasswordResp.new(Result)
    return TChangePasswordResp_from_obj({Result = Result})
end
---@param obj BiosMsg.ChangePasswordResp
function TChangePasswordResp:init_from_obj(obj)
    self.Result = obj.Result
end

function TChangePasswordResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePasswordResp.group)
end

TChangePasswordResp.from_obj = TChangePasswordResp_from_obj

TChangePasswordResp.proto_property = {'Result'}

TChangePasswordResp.default = {''}

function TChangePasswordResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'string', false, errs)

    TChangePasswordResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePasswordResp.proto_property, errs)
    return self
end

function TChangePasswordResp:unpack(_)
    return self.Result
end

BiosMsg.ChangePasswordResp = TChangePasswordResp

---@class BiosMsg.SetBootOrderReq
---@field BootOrderJson string
local TSetBootOrderReq = {}
TSetBootOrderReq.__index = TSetBootOrderReq
TSetBootOrderReq.group = {}

local function TSetBootOrderReq_from_obj(obj)
    return setmetatable(obj, TSetBootOrderReq)
end

function TSetBootOrderReq.new(BootOrderJson)
    return TSetBootOrderReq_from_obj({BootOrderJson = BootOrderJson})
end
---@param obj BiosMsg.SetBootOrderReq
function TSetBootOrderReq:init_from_obj(obj)
    self.BootOrderJson = obj.BootOrderJson
end

function TSetBootOrderReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOrderReq.group)
end

TSetBootOrderReq.from_obj = TSetBootOrderReq_from_obj

TSetBootOrderReq.proto_property = {'BootOrderJson'}

TSetBootOrderReq.default = {''}

function TSetBootOrderReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'BootOrderJson', self.BootOrderJson, 'string', false, errs)

    TSetBootOrderReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOrderReq.proto_property, errs)
    return self
end

function TSetBootOrderReq:unpack(_)
    return self.BootOrderJson
end

BiosMsg.SetBootOrderReq = TSetBootOrderReq

---@class BiosMsg.SetBootOrderResp
---@field OutCode integer
---@field ErrName string
---@field ErrValue string
local TSetBootOrderResp = {}
TSetBootOrderResp.__index = TSetBootOrderResp
TSetBootOrderResp.group = {}

local function TSetBootOrderResp_from_obj(obj)
    return setmetatable(obj, TSetBootOrderResp)
end

function TSetBootOrderResp.new(OutCode, ErrName, ErrValue)
    return TSetBootOrderResp_from_obj({OutCode = OutCode, ErrName = ErrName, ErrValue = ErrValue})
end
---@param obj BiosMsg.SetBootOrderResp
function TSetBootOrderResp:init_from_obj(obj)
    self.OutCode = obj.OutCode
    self.ErrName = obj.ErrName
    self.ErrValue = obj.ErrValue
end

function TSetBootOrderResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOrderResp.group)
end

TSetBootOrderResp.from_obj = TSetBootOrderResp_from_obj

TSetBootOrderResp.proto_property = {'OutCode', 'ErrName', 'ErrValue'}

TSetBootOrderResp.default = {0, '', ''}

function TSetBootOrderResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'OutCode', self.OutCode, 'int32', false, errs)
    validate.Required(prefix .. 'ErrName', self.ErrName, 'string', false, errs)
    validate.Required(prefix .. 'ErrValue', self.ErrValue, 'string', false, errs)

    TSetBootOrderResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOrderResp.proto_property, errs)
    return self
end

function TSetBootOrderResp:unpack(_)
    return self.OutCode, self.ErrName, self.ErrValue
end

BiosMsg.SetBootOrderResp = TSetBootOrderResp

---@class BiosMsg.GetBootOrderReq
local TGetBootOrderReq = {}
TGetBootOrderReq.__index = TGetBootOrderReq
TGetBootOrderReq.group = {}

local function TGetBootOrderReq_from_obj(obj)
    return setmetatable(obj, TGetBootOrderReq)
end

function TGetBootOrderReq.new()
    return TGetBootOrderReq_from_obj({})
end
---@param obj BiosMsg.GetBootOrderReq
function TGetBootOrderReq:init_from_obj(obj)

end

function TGetBootOrderReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBootOrderReq.group)
end

TGetBootOrderReq.from_obj = TGetBootOrderReq_from_obj

TGetBootOrderReq.proto_property = {}

TGetBootOrderReq.default = {}

function TGetBootOrderReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetBootOrderReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBootOrderReq.proto_property, errs)
    return self
end

function TGetBootOrderReq:unpack(_)
end

BiosMsg.GetBootOrderReq = TGetBootOrderReq

---@class BiosMsg.GetBootOrderResp
---@field BootOrderJson string
local TGetBootOrderResp = {}
TGetBootOrderResp.__index = TGetBootOrderResp
TGetBootOrderResp.group = {}

local function TGetBootOrderResp_from_obj(obj)
    return setmetatable(obj, TGetBootOrderResp)
end

function TGetBootOrderResp.new(BootOrderJson)
    return TGetBootOrderResp_from_obj({BootOrderJson = BootOrderJson})
end
---@param obj BiosMsg.GetBootOrderResp
function TGetBootOrderResp:init_from_obj(obj)
    self.BootOrderJson = obj.BootOrderJson
end

function TGetBootOrderResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBootOrderResp.group)
end

TGetBootOrderResp.from_obj = TGetBootOrderResp_from_obj

TGetBootOrderResp.proto_property = {'BootOrderJson'}

TGetBootOrderResp.default = {''}

function TGetBootOrderResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'BootOrderJson', self.BootOrderJson, 'string', false, errs)

    TGetBootOrderResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBootOrderResp.proto_property, errs)
    return self
end

function TGetBootOrderResp:unpack(_)
    return self.BootOrderJson
end

BiosMsg.GetBootOrderResp = TGetBootOrderResp

---@class BiosMsg.SetStartOptionReq
---@field StartOption integer
local TSetStartOptionReq = {}
TSetStartOptionReq.__index = TSetStartOptionReq
TSetStartOptionReq.group = {}

local function TSetStartOptionReq_from_obj(obj)
    return setmetatable(obj, TSetStartOptionReq)
end

function TSetStartOptionReq.new(StartOption)
    return TSetStartOptionReq_from_obj({StartOption = StartOption})
end
---@param obj BiosMsg.SetStartOptionReq
function TSetStartOptionReq:init_from_obj(obj)
    self.StartOption = obj.StartOption
end

function TSetStartOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionReq.group)
end

TSetStartOptionReq.from_obj = TSetStartOptionReq_from_obj

TSetStartOptionReq.proto_property = {'StartOption'}

TSetStartOptionReq.default = {0}

function TSetStartOptionReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'StartOption', self.StartOption, 'uint8', false, errs)

    TSetStartOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionReq.proto_property, errs)
    return self
end

function TSetStartOptionReq:unpack(_)
    return self.StartOption
end

BiosMsg.SetStartOptionReq = TSetStartOptionReq

---@class BiosMsg.SetStartOptionResp
---@field Result integer
local TSetStartOptionResp = {}
TSetStartOptionResp.__index = TSetStartOptionResp
TSetStartOptionResp.group = {}

local function TSetStartOptionResp_from_obj(obj)
    return setmetatable(obj, TSetStartOptionResp)
end

function TSetStartOptionResp.new(Result)
    return TSetStartOptionResp_from_obj({Result = Result})
end
---@param obj BiosMsg.SetStartOptionResp
function TSetStartOptionResp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetStartOptionResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionResp.group)
end

TSetStartOptionResp.from_obj = TSetStartOptionResp_from_obj

TSetStartOptionResp.proto_property = {'Result'}

TSetStartOptionResp.default = {0}

function TSetStartOptionResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int32', false, errs)

    TSetStartOptionResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionResp.proto_property, errs)
    return self
end

function TSetStartOptionResp:unpack(_)
    return self.Result
end

BiosMsg.SetStartOptionResp = TSetStartOptionResp

---@class BiosMsg.SetStartOptionFlagReq
---@field StartOptionFlag integer
local TSetStartOptionFlagReq = {}
TSetStartOptionFlagReq.__index = TSetStartOptionFlagReq
TSetStartOptionFlagReq.group = {}

local function TSetStartOptionFlagReq_from_obj(obj)
    return setmetatable(obj, TSetStartOptionFlagReq)
end

function TSetStartOptionFlagReq.new(StartOptionFlag)
    return TSetStartOptionFlagReq_from_obj({StartOptionFlag = StartOptionFlag})
end
---@param obj BiosMsg.SetStartOptionFlagReq
function TSetStartOptionFlagReq:init_from_obj(obj)
    self.StartOptionFlag = obj.StartOptionFlag
end

function TSetStartOptionFlagReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionFlagReq.group)
end

TSetStartOptionFlagReq.from_obj = TSetStartOptionFlagReq_from_obj

TSetStartOptionFlagReq.proto_property = {'StartOptionFlag'}

TSetStartOptionFlagReq.default = {0}

function TSetStartOptionFlagReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'StartOptionFlag', self.StartOptionFlag, 'uint8', false, errs)

    TSetStartOptionFlagReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionFlagReq.proto_property, errs)
    return self
end

function TSetStartOptionFlagReq:unpack(_)
    return self.StartOptionFlag
end

BiosMsg.SetStartOptionFlagReq = TSetStartOptionFlagReq

---@class BiosMsg.SetStartOptionFlagResp
---@field Result integer
local TSetStartOptionFlagResp = {}
TSetStartOptionFlagResp.__index = TSetStartOptionFlagResp
TSetStartOptionFlagResp.group = {}

local function TSetStartOptionFlagResp_from_obj(obj)
    return setmetatable(obj, TSetStartOptionFlagResp)
end

function TSetStartOptionFlagResp.new(Result)
    return TSetStartOptionFlagResp_from_obj({Result = Result})
end
---@param obj BiosMsg.SetStartOptionFlagResp
function TSetStartOptionFlagResp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetStartOptionFlagResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionFlagResp.group)
end

TSetStartOptionFlagResp.from_obj = TSetStartOptionFlagResp_from_obj

TSetStartOptionFlagResp.proto_property = {'Result'}

TSetStartOptionFlagResp.default = {0}

function TSetStartOptionFlagResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int32', false, errs)

    TSetStartOptionFlagResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionFlagResp.proto_property, errs)
    return self
end

function TSetStartOptionFlagResp:unpack(_)
    return self.Result
end

BiosMsg.SetStartOptionFlagResp = TSetStartOptionFlagResp

---@class BiosMsg.GetCurrentValueSettingReq
---@field ReqKey string
local TGetCurrentValueSettingReq = {}
TGetCurrentValueSettingReq.__index = TGetCurrentValueSettingReq
TGetCurrentValueSettingReq.group = {}

local function TGetCurrentValueSettingReq_from_obj(obj)
    return setmetatable(obj, TGetCurrentValueSettingReq)
end

function TGetCurrentValueSettingReq.new(ReqKey)
    return TGetCurrentValueSettingReq_from_obj({ReqKey = ReqKey})
end
---@param obj BiosMsg.GetCurrentValueSettingReq
function TGetCurrentValueSettingReq:init_from_obj(obj)
    self.ReqKey = obj.ReqKey
end

function TGetCurrentValueSettingReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCurrentValueSettingReq.group)
end

TGetCurrentValueSettingReq.from_obj = TGetCurrentValueSettingReq_from_obj

TGetCurrentValueSettingReq.proto_property = {'ReqKey'}

TGetCurrentValueSettingReq.default = {''}

function TGetCurrentValueSettingReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ReqKey', self.ReqKey, 'string', false, errs)

    TGetCurrentValueSettingReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCurrentValueSettingReq.proto_property, errs)
    return self
end

function TGetCurrentValueSettingReq:unpack(_)
    return self.ReqKey
end

BiosMsg.GetCurrentValueSettingReq = TGetCurrentValueSettingReq

---@class BiosMsg.GetCurrentValueSettingResp
---@field RespValue string
local TGetCurrentValueSettingResp = {}
TGetCurrentValueSettingResp.__index = TGetCurrentValueSettingResp
TGetCurrentValueSettingResp.group = {}

local function TGetCurrentValueSettingResp_from_obj(obj)
    return setmetatable(obj, TGetCurrentValueSettingResp)
end

function TGetCurrentValueSettingResp.new(RespValue)
    return TGetCurrentValueSettingResp_from_obj({RespValue = RespValue})
end
---@param obj BiosMsg.GetCurrentValueSettingResp
function TGetCurrentValueSettingResp:init_from_obj(obj)
    self.RespValue = obj.RespValue
end

function TGetCurrentValueSettingResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCurrentValueSettingResp.group)
end

TGetCurrentValueSettingResp.from_obj = TGetCurrentValueSettingResp_from_obj

TGetCurrentValueSettingResp.proto_property = {'RespValue'}

TGetCurrentValueSettingResp.default = {''}

function TGetCurrentValueSettingResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'RespValue', self.RespValue, 'string', false, errs)

    TGetCurrentValueSettingResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCurrentValueSettingResp.proto_property, errs)
    return self
end

function TGetCurrentValueSettingResp:unpack(_)
    return self.RespValue
end

BiosMsg.GetCurrentValueSettingResp = TGetCurrentValueSettingResp

---@class BiosMsg.ExportBiosConfigReq
---@field ConfigPath string
local TExportBiosConfigReq = {}
TExportBiosConfigReq.__index = TExportBiosConfigReq
TExportBiosConfigReq.group = {}

local function TExportBiosConfigReq_from_obj(obj)
    return setmetatable(obj, TExportBiosConfigReq)
end

function TExportBiosConfigReq.new(ConfigPath)
    return TExportBiosConfigReq_from_obj({ConfigPath = ConfigPath})
end
---@param obj BiosMsg.ExportBiosConfigReq
function TExportBiosConfigReq:init_from_obj(obj)
    self.ConfigPath = obj.ConfigPath
end

function TExportBiosConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosConfigReq.group)
end

TExportBiosConfigReq.from_obj = TExportBiosConfigReq_from_obj

TExportBiosConfigReq.proto_property = {'ConfigPath'}

TExportBiosConfigReq.default = {''}

function TExportBiosConfigReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ConfigPath', self.ConfigPath, 'string', false, errs)

    TExportBiosConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosConfigReq.proto_property, errs)
    return self
end

function TExportBiosConfigReq:unpack(_)
    return self.ConfigPath
end

BiosMsg.ExportBiosConfigReq = TExportBiosConfigReq

---@class BiosMsg.ExportBiosConfigResp
---@field ExportFlag integer
local TExportBiosConfigResp = {}
TExportBiosConfigResp.__index = TExportBiosConfigResp
TExportBiosConfigResp.group = {}

local function TExportBiosConfigResp_from_obj(obj)
    return setmetatable(obj, TExportBiosConfigResp)
end

function TExportBiosConfigResp.new(ExportFlag)
    return TExportBiosConfigResp_from_obj({ExportFlag = ExportFlag})
end
---@param obj BiosMsg.ExportBiosConfigResp
function TExportBiosConfigResp:init_from_obj(obj)
    self.ExportFlag = obj.ExportFlag
end

function TExportBiosConfigResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosConfigResp.group)
end

TExportBiosConfigResp.from_obj = TExportBiosConfigResp_from_obj

TExportBiosConfigResp.proto_property = {'ExportFlag'}

TExportBiosConfigResp.default = {0}

function TExportBiosConfigResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ExportFlag', self.ExportFlag, 'uint8', false, errs)

    TExportBiosConfigResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosConfigResp.proto_property, errs)
    return self
end

function TExportBiosConfigResp:unpack(_)
    return self.ExportFlag
end

BiosMsg.ExportBiosConfigResp = TExportBiosConfigResp

---@class BiosMsg.ImportBiosConfigReq
local TImportBiosConfigReq = {}
TImportBiosConfigReq.__index = TImportBiosConfigReq
TImportBiosConfigReq.group = {}

local function TImportBiosConfigReq_from_obj(obj)
    return setmetatable(obj, TImportBiosConfigReq)
end

function TImportBiosConfigReq.new()
    return TImportBiosConfigReq_from_obj({})
end
---@param obj BiosMsg.ImportBiosConfigReq
function TImportBiosConfigReq:init_from_obj(obj)

end

function TImportBiosConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportBiosConfigReq.group)
end

TImportBiosConfigReq.from_obj = TImportBiosConfigReq_from_obj

TImportBiosConfigReq.proto_property = {}

TImportBiosConfigReq.default = {}

function TImportBiosConfigReq:validate(prefix, errs)
    prefix = prefix or ''

    TImportBiosConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportBiosConfigReq.proto_property, errs)
    return self
end

function TImportBiosConfigReq:unpack(_)
end

BiosMsg.ImportBiosConfigReq = TImportBiosConfigReq

---@class BiosMsg.ImportBiosConfigResp
---@field ExportFlag integer
---@field ExportResult string
local TImportBiosConfigResp = {}
TImportBiosConfigResp.__index = TImportBiosConfigResp
TImportBiosConfigResp.group = {}

local function TImportBiosConfigResp_from_obj(obj)
    return setmetatable(obj, TImportBiosConfigResp)
end

function TImportBiosConfigResp.new(ExportFlag, ExportResult)
    return TImportBiosConfigResp_from_obj({ExportFlag = ExportFlag, ExportResult = ExportResult})
end
---@param obj BiosMsg.ImportBiosConfigResp
function TImportBiosConfigResp:init_from_obj(obj)
    self.ExportFlag = obj.ExportFlag
    self.ExportResult = obj.ExportResult
end

function TImportBiosConfigResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportBiosConfigResp.group)
end

TImportBiosConfigResp.from_obj = TImportBiosConfigResp_from_obj

TImportBiosConfigResp.proto_property = {'ExportFlag', 'ExportResult'}

TImportBiosConfigResp.default = {0, ''}

function TImportBiosConfigResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ExportFlag', self.ExportFlag, 'uint8', false, errs)
    validate.Required(prefix .. 'ExportResult', self.ExportResult, 'string', false, errs)

    TImportBiosConfigResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportBiosConfigResp.proto_property, errs)
    return self
end

function TImportBiosConfigResp:unpack(_)
    return self.ExportFlag, self.ExportResult
end

BiosMsg.ImportBiosConfigResp = TImportBiosConfigResp

---@class BiosMsg.SetBootModeReq
---@field mode integer
local TSetBootModeReq = {}
TSetBootModeReq.__index = TSetBootModeReq
TSetBootModeReq.group = {}

local function TSetBootModeReq_from_obj(obj)
    return setmetatable(obj, TSetBootModeReq)
end

function TSetBootModeReq.new(mode)
    return TSetBootModeReq_from_obj({mode = mode})
end
---@param obj BiosMsg.SetBootModeReq
function TSetBootModeReq:init_from_obj(obj)
    self.mode = obj.mode
end

function TSetBootModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootModeReq.group)
end

TSetBootModeReq.from_obj = TSetBootModeReq_from_obj

TSetBootModeReq.proto_property = {'mode'}

TSetBootModeReq.default = {0}

function TSetBootModeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'mode', self.mode, 'uint8', false, errs)

    TSetBootModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootModeReq.proto_property, errs)
    return self
end

function TSetBootModeReq:unpack(_)
    return self.mode
end

BiosMsg.SetBootModeReq = TSetBootModeReq

---@class BiosMsg.SetBootModeResp
---@field RespCode integer
local TSetBootModeResp = {}
TSetBootModeResp.__index = TSetBootModeResp
TSetBootModeResp.group = {}

local function TSetBootModeResp_from_obj(obj)
    return setmetatable(obj, TSetBootModeResp)
end

function TSetBootModeResp.new(RespCode)
    return TSetBootModeResp_from_obj({RespCode = RespCode})
end
---@param obj BiosMsg.SetBootModeResp
function TSetBootModeResp:init_from_obj(obj)
    self.RespCode = obj.RespCode
end

function TSetBootModeResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootModeResp.group)
end

TSetBootModeResp.from_obj = TSetBootModeResp_from_obj

TSetBootModeResp.proto_property = {'RespCode'}

TSetBootModeResp.default = {0}

function TSetBootModeResp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'RespCode', self.RespCode, 'uint8', false, errs)

    TSetBootModeResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootModeResp.proto_property, errs)
    return self
end

function TSetBootModeResp:unpack(_)
    return self.RespCode
end

BiosMsg.SetBootModeResp = TSetBootModeResp

return BiosMsg
