-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Driver = {}

---@class Driver.ExtendParams
---@field key string
---@field value string
local TExtendParams = {}
TExtendParams.__index = TExtendParams
TExtendParams.group = {}

local function TExtendParams_from_obj(obj)
    return setmetatable(obj, TExtendParams)
end

function TExtendParams.new(dict) return TExtendParams_from_obj(dict) end

---@param obj Driver.ExtendParams
function TExtendParams:init_from_obj(obj) self = obj end

function TExtendParams:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExtendParams.group)
end

TExtendParams.from_obj = TExtendParams_from_obj

TExtendParams.proto_property = {}

TExtendParams.default = {}

TExtendParams.struct = {}

function TExtendParams:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, "string", false, errs,
                          need_convert)

        validate.Optional(prefix .. 'value', v, "string", false, errs,
                          need_convert)

    end

    TExtendParams:remove_error_props(errs, self)
    return self
end

function TExtendParams:unpack(_) return self end

Driver.ExtendParams = TExtendParams

---@class Driver.RmmodRsp
---@field Result boolean
local TRmmodRsp = {}
TRmmodRsp.__index = TRmmodRsp
TRmmodRsp.group = {}

local function TRmmodRsp_from_obj(obj) return setmetatable(obj, TRmmodRsp) end

function TRmmodRsp.new(Result) return TRmmodRsp_from_obj({Result = Result}) end
---@param obj Driver.RmmodRsp
function TRmmodRsp:init_from_obj(obj) self.Result = obj.Result end

function TRmmodRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRmmodRsp.group)
end

TRmmodRsp.from_obj = TRmmodRsp_from_obj

TRmmodRsp.proto_property = {'Result'}

TRmmodRsp.default = {false}

TRmmodRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TRmmodRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TRmmodRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRmmodRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TRmmodRsp:unpack(_) return self.Result end

Driver.RmmodRsp = TRmmodRsp

---@class Driver.RmmodReq
---@field ModulePath string
---@field ExtendParams Driver.ExtendParams
local TRmmodReq = {}
TRmmodReq.__index = TRmmodReq
TRmmodReq.group = {}

local function TRmmodReq_from_obj(obj) return setmetatable(obj, TRmmodReq) end

function TRmmodReq.new(ModulePath, ExtendParams)
    return TRmmodReq_from_obj({
        ModulePath = ModulePath,
        ExtendParams = ExtendParams
    })
end
---@param obj Driver.RmmodReq
function TRmmodReq:init_from_obj(obj)
    self.ModulePath = obj.ModulePath
    self.ExtendParams = obj.ExtendParams
end

function TRmmodReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRmmodReq.group)
end

TRmmodReq.from_obj = TRmmodReq_from_obj

TRmmodReq.proto_property = {'ModulePath', 'ExtendParams'}

TRmmodReq.default = {'', Driver.ExtendParams.default}

TRmmodReq.struct = {
    {name = 'ModulePath', is_array = false, struct = nil},
    {
        name = 'ExtendParams',
        is_array = false,
        struct = Driver.ExtendParams.struct
    }
}

function TRmmodReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    Driver.ExtendParams.new(self.ExtendParams):validate(prefix, errs,
                                                        need_convert)

    validate.Optional(prefix .. 'ModulePath', self.ModulePath, "string", false,
                      errs, need_convert)

    TRmmodReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRmmodReq.proto_property, errs,
                                 need_convert)
    return self
end

function TRmmodReq:unpack(_) return self.ModulePath, self.ExtendParams end

Driver.RmmodReq = TRmmodReq

---@class Driver.InsmodRsp
---@field Result boolean
local TInsmodRsp = {}
TInsmodRsp.__index = TInsmodRsp
TInsmodRsp.group = {}

local function TInsmodRsp_from_obj(obj) return setmetatable(obj, TInsmodRsp) end

function TInsmodRsp.new(Result) return TInsmodRsp_from_obj({Result = Result}) end
---@param obj Driver.InsmodRsp
function TInsmodRsp:init_from_obj(obj) self.Result = obj.Result end

function TInsmodRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInsmodRsp.group)
end

TInsmodRsp.from_obj = TInsmodRsp_from_obj

TInsmodRsp.proto_property = {'Result'}

TInsmodRsp.default = {false}

TInsmodRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TInsmodRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TInsmodRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInsmodRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TInsmodRsp:unpack(_) return self.Result end

Driver.InsmodRsp = TInsmodRsp

---@class Driver.InsmodReq
---@field ModulePath string
---@field ExtendParams Driver.ExtendParams
local TInsmodReq = {}
TInsmodReq.__index = TInsmodReq
TInsmodReq.group = {}

local function TInsmodReq_from_obj(obj) return setmetatable(obj, TInsmodReq) end

function TInsmodReq.new(ModulePath, ExtendParams)
    return TInsmodReq_from_obj({
        ModulePath = ModulePath,
        ExtendParams = ExtendParams
    })
end
---@param obj Driver.InsmodReq
function TInsmodReq:init_from_obj(obj)
    self.ModulePath = obj.ModulePath
    self.ExtendParams = obj.ExtendParams
end

function TInsmodReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInsmodReq.group)
end

TInsmodReq.from_obj = TInsmodReq_from_obj

TInsmodReq.proto_property = {'ModulePath', 'ExtendParams'}

TInsmodReq.default = {'', Driver.ExtendParams.default}

TInsmodReq.struct = {
    {name = 'ModulePath', is_array = false, struct = nil},
    {
        name = 'ExtendParams',
        is_array = false,
        struct = Driver.ExtendParams.struct
    }
}

function TInsmodReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    Driver.ExtendParams.new(self.ExtendParams):validate(prefix, errs,
                                                        need_convert)

    validate.Optional(prefix .. 'ModulePath', self.ModulePath, "string", false,
                      errs, need_convert)

    TInsmodReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInsmodReq.proto_property, errs,
                                 need_convert)
    return self
end

function TInsmodReq:unpack(_) return self.ModulePath, self.ExtendParams end

Driver.InsmodReq = TInsmodReq

Driver.interface = mdb.register_interface(
                       'bmc.kepler.Managers.Security.Proxy.Driver', {}, {
        Insmod = {'a{ss}sa{ss}', 'b', TInsmodReq, TInsmodRsp},
        Rmmod = {'a{ss}sa{ss}', 'b', TRmmodReq, TRmmodRsp}
    }, {})

return Driver
