-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Config = {}

---@class Config.MeasureControlPolicy
---@field MeasureControlPolicy boolean
local TMeasureControlPolicy = {}
TMeasureControlPolicy.__index = TMeasureControlPolicy
TMeasureControlPolicy.group = {}

local function TMeasureControlPolicy_from_obj(obj)
    return setmetatable(obj, TMeasureControlPolicy)
end

function TMeasureControlPolicy.new(MeasureControlPolicy)
    return TMeasureControlPolicy_from_obj({MeasureControlPolicy = MeasureControlPolicy})
end
---@param obj Config.MeasureControlPolicy
function TMeasureControlPolicy:init_from_obj(obj)
    self.MeasureControlPolicy = obj.MeasureControlPolicy
end

function TMeasureControlPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMeasureControlPolicy.group)
end

TMeasureControlPolicy.from_obj = TMeasureControlPolicy_from_obj

TMeasureControlPolicy.proto_property = {'MeasureControlPolicy'}

TMeasureControlPolicy.default = {false}

TMeasureControlPolicy.struct = {{name = 'MeasureControlPolicy', is_array = false, struct = nil}}

function TMeasureControlPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MeasureControlPolicy', self.MeasureControlPolicy, 'bool', false, errs, need_convert)

    TMeasureControlPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMeasureControlPolicy.proto_property, errs, need_convert)
    return self
end

function TMeasureControlPolicy:unpack(_)
    return self.MeasureControlPolicy
end

Config.MeasureControlPolicy = TMeasureControlPolicy

---@class Config.MeasureEnable
---@field MeasureEnable boolean
local TMeasureEnable = {}
TMeasureEnable.__index = TMeasureEnable
TMeasureEnable.group = {}

local function TMeasureEnable_from_obj(obj)
    return setmetatable(obj, TMeasureEnable)
end

function TMeasureEnable.new(MeasureEnable)
    return TMeasureEnable_from_obj({MeasureEnable = MeasureEnable})
end
---@param obj Config.MeasureEnable
function TMeasureEnable:init_from_obj(obj)
    self.MeasureEnable = obj.MeasureEnable
end

function TMeasureEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMeasureEnable.group)
end

TMeasureEnable.from_obj = TMeasureEnable_from_obj

TMeasureEnable.proto_property = {'MeasureEnable'}

TMeasureEnable.default = {false}

TMeasureEnable.struct = {{name = 'MeasureEnable', is_array = false, struct = nil}}

function TMeasureEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MeasureEnable', self.MeasureEnable, 'bool', false, errs, need_convert)

    TMeasureEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMeasureEnable.proto_property, errs, need_convert)
    return self
end

function TMeasureEnable:unpack(_)
    return self.MeasureEnable
end

Config.MeasureEnable = TMeasureEnable

---@class Config.TrustedCenterServerAddr
---@field TrustedCenterServerAddr string
local TTrustedCenterServerAddr = {}
TTrustedCenterServerAddr.__index = TTrustedCenterServerAddr
TTrustedCenterServerAddr.group = {}

local function TTrustedCenterServerAddr_from_obj(obj)
    return setmetatable(obj, TTrustedCenterServerAddr)
end

function TTrustedCenterServerAddr.new(TrustedCenterServerAddr)
    return TTrustedCenterServerAddr_from_obj({TrustedCenterServerAddr = TrustedCenterServerAddr})
end
---@param obj Config.TrustedCenterServerAddr
function TTrustedCenterServerAddr:init_from_obj(obj)
    self.TrustedCenterServerAddr = obj.TrustedCenterServerAddr
end

function TTrustedCenterServerAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTrustedCenterServerAddr.group)
end

TTrustedCenterServerAddr.from_obj = TTrustedCenterServerAddr_from_obj

TTrustedCenterServerAddr.proto_property = {'TrustedCenterServerAddr'}

TTrustedCenterServerAddr.default = {''}

TTrustedCenterServerAddr.struct = {{name = 'TrustedCenterServerAddr', is_array = false, struct = nil}}

function TTrustedCenterServerAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TrustedCenterServerAddr', self.TrustedCenterServerAddr, 'string', false, errs,
        need_convert)

    TTrustedCenterServerAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTrustedCenterServerAddr.proto_property, errs, need_convert)
    return self
end

function TTrustedCenterServerAddr:unpack(_)
    return self.TrustedCenterServerAddr
end

Config.TrustedCenterServerAddr = TTrustedCenterServerAddr

---@class Config.GetTsbLicenseRsp
---@field LicenseType integer
---@field ExpiredTime string
local TGetTsbLicenseRsp = {}
TGetTsbLicenseRsp.__index = TGetTsbLicenseRsp
TGetTsbLicenseRsp.group = {}

local function TGetTsbLicenseRsp_from_obj(obj)
    return setmetatable(obj, TGetTsbLicenseRsp)
end

function TGetTsbLicenseRsp.new(LicenseType, ExpiredTime)
    return TGetTsbLicenseRsp_from_obj({LicenseType = LicenseType, ExpiredTime = ExpiredTime})
end
---@param obj Config.GetTsbLicenseRsp
function TGetTsbLicenseRsp:init_from_obj(obj)
    self.LicenseType = obj.LicenseType
    self.ExpiredTime = obj.ExpiredTime
end

function TGetTsbLicenseRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTsbLicenseRsp.group)
end

TGetTsbLicenseRsp.from_obj = TGetTsbLicenseRsp_from_obj

TGetTsbLicenseRsp.proto_property = {'LicenseType', 'ExpiredTime'}

TGetTsbLicenseRsp.default = {0, ''}

TGetTsbLicenseRsp.struct = {
    {name = 'LicenseType', is_array = false, struct = nil}, {name = 'ExpiredTime', is_array = false, struct = nil}
}

function TGetTsbLicenseRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LicenseType', self.LicenseType, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ExpiredTime', self.ExpiredTime, 'string', false, errs, need_convert)

    TGetTsbLicenseRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTsbLicenseRsp.proto_property, errs, need_convert)
    return self
end

function TGetTsbLicenseRsp:unpack(_)
    return self.LicenseType, self.ExpiredTime
end

Config.GetTsbLicenseRsp = TGetTsbLicenseRsp

---@class Config.GetTsbLicenseReq
local TGetTsbLicenseReq = {}
TGetTsbLicenseReq.__index = TGetTsbLicenseReq
TGetTsbLicenseReq.group = {}

local function TGetTsbLicenseReq_from_obj(obj)
    return setmetatable(obj, TGetTsbLicenseReq)
end

function TGetTsbLicenseReq.new()
    return TGetTsbLicenseReq_from_obj({})
end
---@param obj Config.GetTsbLicenseReq
function TGetTsbLicenseReq:init_from_obj(obj)

end

function TGetTsbLicenseReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTsbLicenseReq.group)
end

TGetTsbLicenseReq.from_obj = TGetTsbLicenseReq_from_obj

TGetTsbLicenseReq.proto_property = {}

TGetTsbLicenseReq.default = {}

TGetTsbLicenseReq.struct = {}

function TGetTsbLicenseReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetTsbLicenseReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTsbLicenseReq.proto_property, errs, need_convert)
    return self
end

function TGetTsbLicenseReq:unpack(_)
end

Config.GetTsbLicenseReq = TGetTsbLicenseReq

---@class Config.RefreshBIOSDigestRsp
---@field TaskId integer
local TRefreshBIOSDigestRsp = {}
TRefreshBIOSDigestRsp.__index = TRefreshBIOSDigestRsp
TRefreshBIOSDigestRsp.group = {}

local function TRefreshBIOSDigestRsp_from_obj(obj)
    return setmetatable(obj, TRefreshBIOSDigestRsp)
end

function TRefreshBIOSDigestRsp.new(TaskId)
    return TRefreshBIOSDigestRsp_from_obj({TaskId = TaskId})
end
---@param obj Config.RefreshBIOSDigestRsp
function TRefreshBIOSDigestRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TRefreshBIOSDigestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefreshBIOSDigestRsp.group)
end

TRefreshBIOSDigestRsp.from_obj = TRefreshBIOSDigestRsp_from_obj

TRefreshBIOSDigestRsp.proto_property = {'TaskId'}

TRefreshBIOSDigestRsp.default = {0}

TRefreshBIOSDigestRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TRefreshBIOSDigestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint8', false, errs, need_convert)

    TRefreshBIOSDigestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefreshBIOSDigestRsp.proto_property, errs, need_convert)
    return self
end

function TRefreshBIOSDigestRsp:unpack(_)
    return self.TaskId
end

Config.RefreshBIOSDigestRsp = TRefreshBIOSDigestRsp

---@class Config.RefreshBIOSDigestReq
local TRefreshBIOSDigestReq = {}
TRefreshBIOSDigestReq.__index = TRefreshBIOSDigestReq
TRefreshBIOSDigestReq.group = {}

local function TRefreshBIOSDigestReq_from_obj(obj)
    return setmetatable(obj, TRefreshBIOSDigestReq)
end

function TRefreshBIOSDigestReq.new()
    return TRefreshBIOSDigestReq_from_obj({})
end
---@param obj Config.RefreshBIOSDigestReq
function TRefreshBIOSDigestReq:init_from_obj(obj)

end

function TRefreshBIOSDigestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefreshBIOSDigestReq.group)
end

TRefreshBIOSDigestReq.from_obj = TRefreshBIOSDigestReq_from_obj

TRefreshBIOSDigestReq.proto_property = {}

TRefreshBIOSDigestReq.default = {}

TRefreshBIOSDigestReq.struct = {}

function TRefreshBIOSDigestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRefreshBIOSDigestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefreshBIOSDigestReq.proto_property, errs, need_convert)
    return self
end

function TRefreshBIOSDigestReq:unpack(_)
end

Config.RefreshBIOSDigestReq = TRefreshBIOSDigestReq

Config.interface = mdb.register_interface('bmc.kepler.Managers.TPCM.Config', {
    TrustedCenterServerAddr = {'s', {'EMIT_CHANGE'}, false, nil, false},
    MeasureEnable = {'b', {'EMIT_CHANGE'}, false, nil, false},
    MeasureControlPolicy = {'b', {'EMIT_CHANGE'}, false, nil, false}
}, {
    RefreshBIOSDigest = {'a{ss}', 'y', TRefreshBIOSDigestReq, TRefreshBIOSDigestRsp},
    GetTsbLicense = {'a{ss}', 'us', TGetTsbLicenseReq, TGetTsbLicenseRsp}
}, {})

return Config
