--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSystemFirmwareVersion = {}

---@class BiosIpmiCmds.SetSystemFirmwareVersionReq
---@field Info string
local TSetSystemFirmwareVersionReq = {}
TSetSystemFirmwareVersionReq.__index = TSetSystemFirmwareVersionReq
TSetSystemFirmwareVersionReq.group = {}

local function TSetSystemFirmwareVersionReq_from_obj(obj)
    return setmetatable(obj, TSetSystemFirmwareVersionReq)
end

function TSetSystemFirmwareVersionReq.new(Info)
    return TSetSystemFirmwareVersionReq_from_obj({Info = Info})
end
---@param obj BiosIpmiCmds.SetSystemFirmwareVersionReq
function TSetSystemFirmwareVersionReq:init_from_obj(obj)
    self.Info = obj.Info
end

function TSetSystemFirmwareVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSystemFirmwareVersionReq.group)
end

TSetSystemFirmwareVersionReq.from_obj = TSetSystemFirmwareVersionReq_from_obj

TSetSystemFirmwareVersionReq.proto_property = {'Info'}

TSetSystemFirmwareVersionReq.default = {''}

TSetSystemFirmwareVersionReq.struct = {{name = 'Info', is_array = false, struct = nil}}

function TSetSystemFirmwareVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetSystemFirmwareVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSystemFirmwareVersionReq.proto_property, errs, need_convert)
    return self
end

function TSetSystemFirmwareVersionReq:unpack(_)
    return self.Info
end

SetSystemFirmwareVersion.SetSystemFirmwareVersionReq = TSetSystemFirmwareVersionReq

---@class BiosIpmiCmds.SetSystemFirmwareVersionRsp
---@field CompletionCode integer
local TSetSystemFirmwareVersionRsp = {}
TSetSystemFirmwareVersionRsp.__index = TSetSystemFirmwareVersionRsp
TSetSystemFirmwareVersionRsp.group = {}

local function TSetSystemFirmwareVersionRsp_from_obj(obj)
    return setmetatable(obj, TSetSystemFirmwareVersionRsp)
end

function TSetSystemFirmwareVersionRsp.new(CompletionCode)
    return TSetSystemFirmwareVersionRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetSystemFirmwareVersionRsp
function TSetSystemFirmwareVersionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetSystemFirmwareVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSystemFirmwareVersionRsp.group)
end

TSetSystemFirmwareVersionRsp.from_obj = TSetSystemFirmwareVersionRsp_from_obj

TSetSystemFirmwareVersionRsp.proto_property = {'CompletionCode'}

TSetSystemFirmwareVersionRsp.default = {0}

TSetSystemFirmwareVersionRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetSystemFirmwareVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetSystemFirmwareVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSystemFirmwareVersionRsp.proto_property, errs, need_convert)
    return self
end

function TSetSystemFirmwareVersionRsp:unpack(_)
    return self.CompletionCode
end

SetSystemFirmwareVersion.SetSystemFirmwareVersionRsp = TSetSystemFirmwareVersionRsp

return SetSystemFirmwareVersion
