--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetKbcStatus = {}

---@class BiosIpmiCmds.SetKbcStatusReq
---@field ManufactureId integer
---@field EventDir integer
---@field DeviceStatus string
local TSetKbcStatusReq = {}
TSetKbcStatusReq.__index = TSetKbcStatusReq
TSetKbcStatusReq.group = {}

local function TSetKbcStatusReq_from_obj(obj)
    return setmetatable(obj, TSetKbcStatusReq)
end

function TSetKbcStatusReq.new(ManufactureId, EventDir, DeviceStatus)
    return TSetKbcStatusReq_from_obj({ManufactureId = ManufactureId, EventDir = EventDir, DeviceStatus = DeviceStatus})
end
---@param obj BiosIpmiCmds.SetKbcStatusReq
function TSetKbcStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.EventDir = obj.EventDir
    self.DeviceStatus = obj.DeviceStatus
end

function TSetKbcStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetKbcStatusReq.group)
end

TSetKbcStatusReq.from_obj = TSetKbcStatusReq_from_obj

TSetKbcStatusReq.proto_property = {'ManufactureId', 'EventDir', 'DeviceStatus'}

TSetKbcStatusReq.default = {0, 0, ''}

TSetKbcStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'EventDir', is_array = false, struct = nil},
    {name = 'DeviceStatus', is_array = false, struct = nil}
}

function TSetKbcStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventDir', self.EventDir, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceStatus', self.DeviceStatus, 'string', false, errs, need_convert)

    TSetKbcStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetKbcStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetKbcStatusReq:unpack(_)
    return self.ManufactureId, self.EventDir, self.DeviceStatus
end

SetKbcStatus.SetKbcStatusReq = TSetKbcStatusReq

---@class BiosIpmiCmds.SetKbcStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetKbcStatusRsp = {}
TSetKbcStatusRsp.__index = TSetKbcStatusRsp
TSetKbcStatusRsp.group = {}

local function TSetKbcStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetKbcStatusRsp)
end

function TSetKbcStatusRsp.new(CompletionCode, ManufactureId)
    return TSetKbcStatusRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetKbcStatusRsp
function TSetKbcStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetKbcStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetKbcStatusRsp.group)
end

TSetKbcStatusRsp.from_obj = TSetKbcStatusRsp_from_obj

TSetKbcStatusRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetKbcStatusRsp.default = {0, 0}

TSetKbcStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetKbcStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetKbcStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetKbcStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetKbcStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetKbcStatus.SetKbcStatusRsp = TSetKbcStatusRsp

return SetKbcStatus
