--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCertificateAssertion = {}

---@class BiosIpmiCmds.SetCertificateAssertionReq
---@field ManufactureId integer
---@field EventType integer
---@field Info string
local TSetCertificateAssertionReq = {}
TSetCertificateAssertionReq.__index = TSetCertificateAssertionReq
TSetCertificateAssertionReq.group = {}

local function TSetCertificateAssertionReq_from_obj(obj)
    return setmetatable(obj, TSetCertificateAssertionReq)
end

function TSetCertificateAssertionReq.new(ManufactureId, EventType, Info)
    return TSetCertificateAssertionReq_from_obj({ManufactureId = ManufactureId, EventType = EventType, Info = Info})
end
---@param obj BiosIpmiCmds.SetCertificateAssertionReq
function TSetCertificateAssertionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.EventType = obj.EventType
    self.Info = obj.Info
end

function TSetCertificateAssertionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCertificateAssertionReq.group)
end

TSetCertificateAssertionReq.from_obj = TSetCertificateAssertionReq_from_obj

TSetCertificateAssertionReq.proto_property = {'ManufactureId', 'EventType', 'Info'}

TSetCertificateAssertionReq.default = {0, 0, ''}

TSetCertificateAssertionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'EventType', is_array = false, struct = nil},
    {name = 'Info', is_array = false, struct = nil}
}

function TSetCertificateAssertionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventType', self.EventType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetCertificateAssertionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCertificateAssertionReq.proto_property, errs, need_convert)
    return self
end

function TSetCertificateAssertionReq:unpack(_)
    return self.ManufactureId, self.EventType, self.Info
end

SetCertificateAssertion.SetCertificateAssertionReq = TSetCertificateAssertionReq

---@class BiosIpmiCmds.SetCertificateAssertionRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetCertificateAssertionRsp = {}
TSetCertificateAssertionRsp.__index = TSetCertificateAssertionRsp
TSetCertificateAssertionRsp.group = {}

local function TSetCertificateAssertionRsp_from_obj(obj)
    return setmetatable(obj, TSetCertificateAssertionRsp)
end

function TSetCertificateAssertionRsp.new(CompletionCode, ManufactureId)
    return TSetCertificateAssertionRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetCertificateAssertionRsp
function TSetCertificateAssertionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetCertificateAssertionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCertificateAssertionRsp.group)
end

TSetCertificateAssertionRsp.from_obj = TSetCertificateAssertionRsp_from_obj

TSetCertificateAssertionRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetCertificateAssertionRsp.default = {0, 0}

TSetCertificateAssertionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetCertificateAssertionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetCertificateAssertionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCertificateAssertionRsp.proto_property, errs, need_convert)
    return self
end

function TSetCertificateAssertionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetCertificateAssertion.SetCertificateAssertionRsp = TSetCertificateAssertionRsp

return SetCertificateAssertion
