--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBiosBootInfo = {}

---@class BiosIpmiCmds.SetBiosBootInfoReq
---@field ManufactureId integer
---@field BiosId integer
---@field PropOption integer
---@field PropLen integer
---@field Information string
local TSetBiosBootInfoReq = {}
TSetBiosBootInfoReq.__index = TSetBiosBootInfoReq
TSetBiosBootInfoReq.group = {}

local function TSetBiosBootInfoReq_from_obj(obj)
    return setmetatable(obj, TSetBiosBootInfoReq)
end

function TSetBiosBootInfoReq.new(ManufactureId, BiosId, PropOption, PropLen, Information)
    return TSetBiosBootInfoReq_from_obj({
        ManufactureId = ManufactureId,
        BiosId = BiosId,
        PropOption = PropOption,
        PropLen = PropLen,
        Information = Information
    })
end
---@param obj BiosIpmiCmds.SetBiosBootInfoReq
function TSetBiosBootInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.PropOption = obj.PropOption
    self.PropLen = obj.PropLen
    self.Information = obj.Information
end

function TSetBiosBootInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosBootInfoReq.group)
end

TSetBiosBootInfoReq.from_obj = TSetBiosBootInfoReq_from_obj

TSetBiosBootInfoReq.proto_property = {'ManufactureId', 'BiosId', 'PropOption', 'PropLen', 'Information'}

TSetBiosBootInfoReq.default = {0, 0, 0, 0, ''}

TSetBiosBootInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'PropOption', is_array = false, struct = nil}, {name = 'PropLen', is_array = false, struct = nil},
    {name = 'Information', is_array = false, struct = nil}
}

function TSetBiosBootInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PropOption', self.PropOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PropLen', self.PropLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Information', self.Information, 'string', false, errs, need_convert)

    TSetBiosBootInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosBootInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetBiosBootInfoReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.PropOption, self.PropLen, self.Information
end

SetBiosBootInfo.SetBiosBootInfoReq = TSetBiosBootInfoReq

---@class BiosIpmiCmds.SetBiosBootInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetBiosBootInfoRsp = {}
TSetBiosBootInfoRsp.__index = TSetBiosBootInfoRsp
TSetBiosBootInfoRsp.group = {}

local function TSetBiosBootInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosBootInfoRsp)
end

function TSetBiosBootInfoRsp.new(CompletionCode, ManufactureId)
    return TSetBiosBootInfoRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetBiosBootInfoRsp
function TSetBiosBootInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetBiosBootInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosBootInfoRsp.group)
end

TSetBiosBootInfoRsp.from_obj = TSetBiosBootInfoRsp_from_obj

TSetBiosBootInfoRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetBiosBootInfoRsp.default = {0, 0}

TSetBiosBootInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetBiosBootInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetBiosBootInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosBootInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetBiosBootInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetBiosBootInfo.SetBiosBootInfoRsp = TSetBiosBootInfoRsp

return SetBiosBootInfo
