--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetChannelInfo = {}

---@class BiosIpmiCmds.GetChannelInfoReq
---@field GetOption integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetChannelInfoReq = {}
TGetChannelInfoReq.__index = TGetChannelInfoReq
TGetChannelInfoReq.group = {}

local function TGetChannelInfoReq_from_obj(obj)
    return setmetatable(obj, TGetChannelInfoReq)
end

function TGetChannelInfoReq.new(GetOption, SetSelector, BlockSelector)
    return
        TGetChannelInfoReq_from_obj({GetOption = GetOption, SetSelector = SetSelector, BlockSelector = BlockSelector})
end
---@param obj BiosIpmiCmds.GetChannelInfoReq
function TGetChannelInfoReq:init_from_obj(obj)
    self.GetOption = obj.GetOption
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetChannelInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChannelInfoReq.group)
end

TGetChannelInfoReq.from_obj = TGetChannelInfoReq_from_obj

TGetChannelInfoReq.proto_property = {'GetOption', 'SetSelector', 'BlockSelector'}

TGetChannelInfoReq.default = {0, 0, 0}

TGetChannelInfoReq.struct = {
    {name = 'GetOption', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetChannelInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetOption', self.GetOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)

    TGetChannelInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChannelInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetChannelInfoReq:unpack(_)
    return self.GetOption, self.SetSelector, self.BlockSelector
end

GetChannelInfo.GetChannelInfoReq = TGetChannelInfoReq

---@class BiosIpmiCmds.GetChannelInfoRsp
---@field CompletionCode integer
---@field ParameterRevision integer
---@field Info string
local TGetChannelInfoRsp = {}
TGetChannelInfoRsp.__index = TGetChannelInfoRsp
TGetChannelInfoRsp.group = {}

local function TGetChannelInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetChannelInfoRsp)
end

function TGetChannelInfoRsp.new(CompletionCode, ParameterRevision, Info)
    return TGetChannelInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterRevision = ParameterRevision,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetChannelInfoRsp
function TGetChannelInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterRevision = obj.ParameterRevision
    self.Info = obj.Info
end

function TGetChannelInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChannelInfoRsp.group)
end

TGetChannelInfoRsp.from_obj = TGetChannelInfoRsp_from_obj

TGetChannelInfoRsp.proto_property = {'CompletionCode', 'ParameterRevision', 'Info'}

TGetChannelInfoRsp.default = {0, 0, ''}

TGetChannelInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterRevision', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TGetChannelInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterRevision', self.ParameterRevision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetChannelInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChannelInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetChannelInfoRsp:unpack(_)
    return self.CompletionCode, self.ParameterRevision, self.Info
end

GetChannelInfo.GetChannelInfoRsp = TGetChannelInfoRsp

return GetChannelInfo
